"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var isNil_1 = __importDefault(require("./isNil"));
var toUpper_1 = __importDefault(require("./toUpper"));
/**
 * 转换字符串 str 的首字母为大写。
 * @param str [string=''] (string): 要转换的字符串
 * @returns (string): 返回转换后的字符串
 * @example
 * _.upperFirst('fred');
 * // => 'Fred'
 *
 * _.upperFirst('FRED');
 * // => 'FRED'
 */
function upperFirst(str) {
    if (str === void 0) { str = ''; }
    if ((0, isNil_1.default)(str)) {
        return str;
    }
    return (0, toUpper_1.default)(str[0]) + str.slice(1);
}
exports.default = upperFirst;
