import { PathInfo as CrossPlatformPathInfo } from '../common/util/path-info.js';
import { ProjectModel } from '@ohos/hvigor-ohos-plugin/src/model/project/project-model.js';
import { SdkPathInfo } from '../common/util/sdk-path-info.js';
import { OhosLogger } from '@ohos/hvigor-ohos-plugin/src/utils/log/ohos-logger.js';
/**
 * 跨平台基础服务类
 *
 * @since 2022/12/12
 */
declare class CrossPlatformService {
    isCrossPlatform: boolean | undefined;
    isApplication: boolean | undefined;
    private projectModel;
    private crossPlatformPathInfo;
    private sdkInfo;
    private sdkPathInfo;
    private readonly log;
    initService(projectModel: ProjectModel): void;
    initSdkInfo(): void;
    setup(): Promise<void>;
    isDebug(): boolean;
    getArkUIXSdkPathInfo(): SdkPathInfo;
    getPathInfo(): CrossPlatformPathInfo;
    getLogger(): OhosLogger;
    isCrossPlatformProject(): boolean;
    getProjectArkUIXSdkPath(): string;
}
export declare const crossPlatformService: CrossPlatformService;
export declare const logger: OhosLogger;
export {};
