#!/usr/bin/env node
"use strict";
/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2021-2022. All rights reserved.
 *
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = __importDefault(require("path"));
// 初始化命令行和日志等级
const cli_js_1 = require("../src/cli/main/cli.js");
const cliOptions = (0, cli_js_1.parseCommand)();
// 初始化nodePath同时后台启动一个daemon
const daemon_process_factory_js_1 = require("../src/base/daemon/process/daemon-process-factory.js");
const prepare_node_path_js_1 = require("../src/cli/wrapper/prepare-node-path.js");
const util_js_1 = require("../src/cli/wrapper/util.js");
const const_1 = require("../src/common/const/const");
const hvigorProjectHome = (0, util_js_1.getHvigorProjectHome)();
(0, prepare_node_path_js_1.initNodePath)(path_1.default.join(hvigorProjectHome, const_1.WORK_SPACE));
if (needStartDaemon(cliOptions)) {
    daemon_process_factory_js_1.defaultDaemonServerFactory.createDaemonFork();
}
(0, cli_js_1.startHvigorBuild)(cliOptions);
// 如果不是stop 和 status命令  且是daemon模式
function needStartDaemon(cliArgv) {
    return !cliArgv.stopDaemon && // --stop-daemon
        !cliArgv.stopDaemonAll && // --stop-daemon-all
        !cliArgv.statusDaemon && // --status
        cliArgv.daemon !== false; // daemon模式或未设置默认为daemon
}
//# sourceMappingURL=hvigor.js.map