export declare enum CompareModel {
    EQUAL = "equal",
    INCLUDE = "include"
}
export declare type PropName = string | number | symbol;
export declare type KVSeem = {
    [P in keyof any]?: any;
};
export declare type PredicateParam = PropName | [PropName, any] | KVSeem;
export declare type PredicateParamFunc = (value: any, index: number, array: Array<any>) => Boolean;
export declare enum ArrayDirection {
    LEFT = "left",
    RIGHT = "right"
}
export declare function checkArrayLenValid(target: any): Boolean;
export declare function getValidIndex(target?: any, defaultVal?: number): number;
/**
 * 将目标对象包装成一个迭代函数
 * @param target
 * @returns
 */
export declare function wrapIterateeFromObject(target: any): (data: any) => boolean | Boolean;
/**
 * 判断指定的key在目标对象是否存在，且对象非空
 * @param key
 * @returns
 */
export declare function warpIterateeFromKey(key: any): (data: any) => any;
/**
 * 针对对象(语法糖类似)来包装成迭代器函数。
 * @param fn
 * @returns
 */
export declare function wrapIteratee(fn: PredicateParam | PredicateParamFunc): PredicateParamFunc;
/**
 * 深度比对元素
 * @param source
 * @param target
 * @returns
 */
export declare function basicCompare(source: any, target: any, compareModel?: CompareModel): boolean | Boolean;
/**
 * 对比Object
 * @param source
 * @param target
 * @param compareModel
 * @returns
 */
export declare function basicCompareObject(source: Object, target: Object, compareModel?: CompareModel): Boolean;
/**
 * 对比Set
 * @param source
 * @param target
 * @param compareModel
 * @returns
 */
export declare function basicCompareSet(source: Set<any>, target: Set<any>, compareModel?: CompareModel): Boolean;
/**
 * 对比map
 * @param source
 * @param target
 * @param compareModel
 * @returns
 */
export declare function basicCompareMap(source: Map<any, any>, target: Map<any, any>, compareModel?: CompareModel): Boolean;
/**
 * 对比数组
 * @param source
 * @param target
 * @param compareModel
 * @returns
 */
export declare function basicCompareArray(source: Array<any>, target: Array<any>, compareModel?: CompareModel): Boolean;
