"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.baseIsEqual = void 0;
var getTag_1 = __importDefault(require("./getTag"));
var Stack_1 = require("./Stack");
var equalArrays_1 = require("./equalArrays");
var equalByTag_1 = require("./equalByTag");
var equalObjects_1 = require("./equalObjects");
var isObjectLike_1 = __importDefault(require("../isObjectLike"));
var isArray_1 = __importDefault(require("../isArray"));
var isTypedArray_1 = __importDefault(require("../isTypedArray"));
function baseIsEqual(value, other, bitmask, customizer, stack) {
    if (value === other) {
        return true;
    }
    if (value == null || other == null || (!(0, isObjectLike_1.default)(value) && !(0, isObjectLike_1.default)(other))) {
        return Number.isNaN(value) && Number.isNaN(other);
    }
    return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
}
exports.baseIsEqual = baseIsEqual;
var COMPARE_PARTIAL_FLAG = 1;
var argsTag = '[object Arguments]';
var arrayTag = '[object Array]';
var objectTag = '[object Object]';
var objectProto = Object.prototype;
var hasOwnProperty = objectProto.hasOwnProperty;
function baseIsEqualDeep(obj, other, bitmask, customizer, equalFunc, stack) {
    var innerStack = stack;
    var objIsArr = (0, isArray_1.default)(obj);
    var othIsArr = (0, isArray_1.default)(other);
    var objTag = objIsArr ? arrayTag : (0, getTag_1.default)(obj);
    var othTag = othIsArr ? arrayTag : (0, getTag_1.default)(other);
    objTag = objTag === argsTag ? objectTag : objTag;
    othTag = othTag === argsTag ? objectTag : othTag;
    var objIsObj = objTag === objectTag;
    var othIsObj = othTag === objectTag;
    var isSameTag = objTag === othTag;
    var retTagAndArray = isEqualByArrayAndTag(isSameTag, objIsObj, innerStack, objIsArr, obj, other, bitmask, customizer, equalFunc, objTag);
    if (!Number.isNaN(retTagAndArray)) {
        return retTagAndArray;
    }
    var ret = judgeEqualByFunc(bitmask, objIsObj, obj, other, othIsObj, innerStack, equalFunc, customizer);
    if (!Number.isNaN(ret)) {
        return ret;
    }
    if (!isSameTag) {
        return false;
    }
    if (!innerStack) {
        innerStack = new Stack_1.Stack(undefined);
    }
    return (0, equalObjects_1.equalObjects)(obj, other, bitmask, customizer, equalFunc, innerStack);
}
function isEqualByArrayAndTag(isSameTag, objIsObj, innerStackParam, objIsArr, obj, other, bitmask, customizer, equalFunc, objTag) {
    var innerStack = innerStackParam;
    if (isSameTag && !objIsObj) {
        if (!innerStack) {
            innerStack = new Stack_1.Stack(undefined);
        }
        return (objIsArr || (0, isTypedArray_1.default)(obj))
            ? (0, equalArrays_1.equalArrays)(obj, other, bitmask, customizer, equalFunc, innerStack)
            : (0, equalByTag_1.equalByTag)(obj, other, objTag, bitmask, customizer, equalFunc, innerStack);
    }
    return NaN;
}
function judgeEqualByFunc(bitmask, objIsObj, obj, other, othIsObj, innerStackParam, equalFunc, customizer) {
    var innerStack = innerStackParam;
    if (!(bitmask & COMPARE_PARTIAL_FLAG)) {
        var objIsWrapped = objIsObj && hasOwnProperty.call(obj, '__wrapped__');
        var othIsWrapped = othIsObj && hasOwnProperty.call(other, '__wrapped__');
        if (objIsWrapped || othIsWrapped) {
            var objUnwrapped = objIsWrapped ? obj.value() : obj;
            var othUnwrapped = othIsWrapped ? other.value() : other;
            if (!innerStack) {
                innerStack = new Stack_1.Stack(undefined);
            }
            return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, innerStack);
        }
    }
    return NaN;
}
