"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * 比较两个值完全一致，包括类型。
 * 详细参看标准 [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 *
 * @category Lang
 * @param {*} value 待比较的对象
 * @param {*} other 被比较的对象.
 * @returns {boolean} 如果相等则返回 `true`，否则返回 `false`.
 * @example
 *
 * const object = { 'a': 1 }
 * const other = { 'a': 1 }
 *
 * eq(object, object)
 * // => true
 *
 * eq(object, other)
 * // => false
 *
 * eq('a', 'a')
 * // => true
 *
 * eq('a', Object('a'))
 * // => false
 *
 * eq(NaN, NaN)
 * // => true
 */
function eq(value, other) {
    if (value === void 0) { value = undefined; }
    if (other === void 0) { other = undefined; }
    // eslint-disable-next-line no-self-compare
    return value === other || (value !== value && other !== other);
}
exports.default = eq;
