"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * 将 input 中的所有元素转换为由 separator 分隔的字符串。
 * @param input
 * @param separator
 */
function join(input, separator) {
    if (!Array.isArray(input)) {
        return '';
    }
    // 对separator的预处理
    var newSeparator = separator === null ? 'null' : separator;
    newSeparator = newSeparator === undefined ? ',' : newSeparator;
    newSeparator = Array.isArray(newSeparator) && newSeparator.length === 0 ? '' : newSeparator;
    newSeparator = Array.isArray(newSeparator) && newSeparator.length > 0 ? newSeparator.join(',') : newSeparator;
    return input.join(newSeparator);
}
exports.default = join;
