export interface TemplateSettings {
    /**
     * escape转义模板分隔符
     *
     */
    escape?: RegExp;
    /**
     * eval模板分隔符
     *
     */
    evaluate?: RegExp;
    /**
     * 插值模板分隔符
     */
    interpolate?: RegExp;
    /**
     * 导入对象到模板中作为自由变量
     */
    imports?: Record<string, any>;
    /**
     * 数据对象的变量名
     */
    variable?: string;
}
/**
 * wdk 默认的模板配置
 */
declare const templateSettings: {
    escape: RegExp;
    evaluate: RegExp;
    interpolate: RegExp;
    variable: string;
    imports: {
        _: any;
    };
};
export default templateSettings;
