"use strict";
/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2023. All rights reserved.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var toFinite_1 = __importDefault(require("./toFinite"));
var isNaN_1 = __importDefault(require("./isNaN"));
/**
 * 将指定的 `value` 转换为整数，转换结果 NaN 时，返回 0；
 * 如果传入值是个小数，它将截断小数部分。
 *
 * **注意:** 这个方法并不是完全的 ECMA 的这个标准一致。
 * [`ToInteger`](http://www.ecma-international.org/ecma-262/7.0/#sec-tointeger)。
 *
 * @since 1.0.0
 * @category Lang
 * @param {*} value 待转换的数据
 * @returns {number} 转换之后的整数
 * @example
 * ```
 * _.toInteger(3.2);
 * // => 3
 *
 * _.toInteger(Number.MIN_VALUE);
 * // => 0
 *
 * _.toInteger(Infinity);
 * // => 1.7976931348623157e+308
 *
 * _.toInteger('3.2');
 * // => 3
 * ```
 */
function toInteger(value) {
    var result = (0, toFinite_1.default)(value);
    var remainder = result % 1;
    if ((0, isNaN_1.default)(result)) {
        return 0;
    }
    return remainder ? result - remainder : result;
}
exports.default = toInteger;
