"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var isNil_1 = __importDefault(require("./isNil"));
var toLowerCase = String ? String.prototype.toLowerCase : undefined;
/**
 * 将整个字符串转换成小写字母返回，跟 String#toLowerCase 基本类似
 *
 * @since 1.0.0
 *
 * @param [str=''] (string) 待转换的字符串
 * @returns (string): 返回的小写字符串。
 *
 * @example
 * _.toLower('--Foo-Bar--');
 * // => '--foo-bar--'
 *
 * _.toLower('fooBar');
 * // => 'foobar'
 *
 * _.toLower('__FOO_BAR__');
 * // => '__foo_bar__'
 */
function toLower(str) {
    if (str === void 0) { str = ''; }
    if ((0, isNil_1.default)(str)) {
        return str;
    }
    return toLowerCase.call(str);
}
exports.default = toLower;
