"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("./common/utils");
/**
 * 从string字符串中移除前面的 空格 或 指定的字符。
 * @param value: 要处理的字符串
 * @param chars: 指定字符
 */
function trimStart(value, chars) {
    if (value === null || value === undefined) {
        return '';
    }
    var charSet = chars ? new Set(chars.split('')).add(' ') : new Set(utils_1.whiteSpace);
    var array = value.split('');
    var startIndex = array.length;
    for (var i = 0; i < array.length; i++) {
        if (!charSet.has(array[i])) {
            startIndex = i;
            break;
        }
    }
    return array.slice(startIndex, array.length).join('');
}
exports.default = trimStart;
