"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var identity_1 = __importDefault(require("./identity"));
var sameValueZero_1 = __importDefault(require("./common/sameValueZero"));
var isNil_1 = __importDefault(require("./isNil"));
var isArray_1 = __importDefault(require("./isArray"));
var get_1 = __importDefault(require("./get"));
var isArrayLike_1 = __importDefault(require("./isArrayLike"));
var keys_1 = __importDefault(require("./keys"));
var isEqual_1 = __importDefault(require("./isEqual"));
function baseUniqByFunc(array, iterator) {
    var result = [];
    var computedValue = [];
    if ((0, isNil_1.default)(array) || !(0, isArrayLike_1.default)(array)) {
        return result;
    }
    var len = array.length;
    var _loop_1 = function (i) {
        var item = array[i];
        var value = iterator(item);
        var findIdx = computedValue.findIndex(function (computed) {
            return (0, sameValueZero_1.default)(value, computed);
        });
        if (findIdx === -1) {
            result.push(item);
            computedValue.push(value);
        }
    };
    for (var i = 0; i < len; i++) {
        _loop_1(i);
    }
    return result;
}
function stringGet(key) {
    return function (value) { return (0, get_1.default)(value, key); };
}
function arrayGet(iteratee) {
    return function (obj) {
        var path = iteratee[0];
        var value = iteratee[1];
        var targetValue = (0, get_1.default)(obj, path);
        return value === targetValue;
    };
}
function objectGet(iteratee) {
    var e_1, _a;
    var allKeys = (0, keys_1.default)(iteratee);
    var iterateeValues = [];
    try {
        for (var allKeys_1 = __values(allKeys), allKeys_1_1 = allKeys_1.next(); !allKeys_1_1.done; allKeys_1_1 = allKeys_1.next()) {
            var oneKey = allKeys_1_1.value;
            iterateeValues.push([oneKey, iteratee[oneKey]]);
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (allKeys_1_1 && !allKeys_1_1.done && (_a = allKeys_1.return)) _a.call(allKeys_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return function (obj) {
        var len = iterateeValues.length;
        for (var i = 0; i < len; i++) {
            var iterm = iterateeValues[i];
            var key = iterm[0];
            var objValue = obj[key];
            if (!(0, isEqual_1.default)(objValue, iterm[1])) {
                return false;
            }
        }
        return true;
    };
}
function numGet(num) {
    return function (value) { return value[num]; };
}
/**
 * 这个方法类似_.uniq ，除了它接受一个 iteratee （迭代函数），调用每一个数组（array）的每个元素以产生唯一性计算的标准。
 * iteratee 调用时会传入一个参数：(value)。
 *
 * 对 iteratee 参数详细规则描述
 * - iteratee 为 Array ，那么将会调用 `matchesProperty` 函数创建一个函数。
 *   这个函数会查找传入对象 path 为 iteratee[0] 上，是否有 iteratee[1]值，如果有则返回true，否则返回false。
 * - iteratee 为 Object，那么将会调用 `matches` 函数创建一个函数。
 *   这个函数会检查传入对象，如果拥有与iteratee相同的属性值返回 true，否则返回 false。
 * - iteratee 为 String，那么调用 `property`函数创建一个函数。
 *   该函数会返回给定对象 path 为 iteratee 的值。
 * - iteratee 为 Number，那么会调用 `property`函数创建一个函数。
 *   该函数会返回给定对象 path 为 iteratee 的值。
 * - iteratee 为 Function， 会直接调用 iteratee 遍历 array 中的每一个对象，其值用于是否为重复值得比较。
 *
 * @param array (Array): 要检查的数组。
 * @param [iteratee=_.identity] (Array|Function|Object|string): 迭代函数，调用每个元素。
 * @returns (Array): 返回新的去重后的数组。
 * @example
 * _.uniqBy([2.1, 1.2, 2.3], Math.floor);
 * // => [2.1, 1.2]
 *
 * // The `_.property` iteratee shorthand.
 * _.uniqBy([{ 'x': 1 }, { 'x': 2 }, { 'x': 1 }], 'x');
 * // => [{ 'x': 1 }, { 'x': 2 }]
 */
function uniqBy(array, iteratee) {
    if (iteratee === void 0) { iteratee = identity_1.default; }
    var iterator = iteratee;
    if ((0, isNil_1.default)(iterator)) {
        iterator = identity_1.default;
    }
    var iteratorType = typeof iterator;
    if (iteratorType === 'function') {
        return baseUniqByFunc(array, iterator);
    }
    if (iteratorType === 'number') {
        return baseUniqByFunc(array, numGet(iterator));
    }
    if (iteratorType === 'string') {
        return baseUniqByFunc(array, stringGet(iterator));
    }
    if ((0, isArray_1.default)(iterator)) {
        return baseUniqByFunc(array, arrayGet(iterator));
    }
    if (iteratorType === 'object') {
        return baseUniqByFunc(array, objectGet(iterator));
    }
    return baseUniqByFunc(array, identity_1.default);
}
exports.default = uniqBy;
