"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var stringToPaths_1 = require("./common/stringToPaths");
/**
 * 剔除obj对象中根据rawPath指定的路径找到的属性和对应的值，并返回是否移除成功。
 * 如果路径遍历时提前遇到undefined或者null则直接返回true
 * @param obj，要剔除属性的对象
 * @param rawPath，要剔除的属性对应的路径
 * @return，一个boolean值，代表属性是否移除成功
 */
function unset(obj, rawPath) {
    var e_1, _a;
    if (obj === null || obj === undefined || rawPath === null || rawPath === undefined) {
        return true;
    }
    var path = (0, stringToPaths_1.getObjValidPathFromGeneralPath)(obj, rawPath);
    if (!path.length) {
        return true;
    }
    var tmpObj = obj;
    try {
        for (var _b = __values(path.splice(0, path.length - 1)), _c = _b.next(); !_c.done; _c = _b.next()) {
            var attri = _c.value;
            tmpObj = tmpObj[attri];
            if (tmpObj === null || tmpObj === undefined) {
                break;
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_1) throw e_1.error; }
    }
    if (tmpObj === null || tmpObj === undefined) {
        return true;
    }
    try {
        return delete tmpObj[path.pop()];
    }
    catch (_d) {
        return false;
    }
}
exports.default = unset;
