"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.defaultDaemonServerFactory=exports.DaemonProcessFactory=void 0;const child_process_1=require("child_process"),crypto_1=require("crypto"),path_1=__importDefault(require("path")),process_1=__importDefault(require("process")),util_js_1=require("../../../cli/wrapper/util.js"),wrapper_const_js_1=require("../../../cli/wrapper/wrapper-const.js"),hash_util_js_1=require("../../../common/util/hash-util.js"),pretty_hrtime_js_1=__importDefault(require("../../../common/util/pretty-hrtime.js")),hvigor_config_reader_js_1=require("../../util/hvigor-config-reader.js"),daemon_const_js_1=require("../const/daemon-const.js"),hvigor_daemon_client_log_js_1=require("../log/hvigor-daemon-client-log.js"),daemon_client_registry_js_1=require("../registry/daemon-client-registry.js"),daemon_info_js_1=require("../registry/daemon-info.js"),session_id_js_1=require("../session/session-id.js"),log=hvigor_daemon_client_log_js_1.HvigorDaemonClientLogger.getLogger("daemon-client");class DaemonProcessFactory{constructor(){this.createDaemonPromise=void 0,this.childExecArgv=this.calcChildExecArgv()}async getProjectCompatibleIdleDaemon(e=!0){const o=daemon_client_registry_js_1.defaultDaemonClientRegistry.findProjectDaemon();if(void 0===o){if(log.debug(`hvigor client: Cannot find a valid daemon for project, projectPath=${process_1.default.cwd()}`),daemon_client_registry_js_1.defaultDaemonClientRegistry.isAvailableDaemonOverLimit()){const e=daemon_client_registry_js_1.defaultDaemonClientRegistry.findIdleDaemonWithLRU();if(void 0===e)return void log.debug("hvigor client: Cannot find another idle daemon. This build will be executed with no-daemon mode.");{const o=e.pid;return log.debug(`hvigor client: Idle daemon (pid=${o}) will be stopped, and a new daemon will be created.`),this.killOldProcessAndCreateNew(e,"daemon process exceeds the upper limit.")}}return this.createNewIdleDaemon(e)}const r=function(e){return e.hvigorVersion!==wrapper_const_js_1.CUR_HVIGOR_VERSION}(o),t=function(e,o){return log.debug(`check node env with process execArgv, execArgv=${o}`),e.nodeVersion!==process_1.default.version||e.nodeParams!==(0,hash_util_js_1.hash)(`${(0,util_js_1.getCurrentProjectCacheDirHash)()}${o.toString()}`)}(o,this.childExecArgv);return r||t?(log.info(`hvigor client: The argument passed to Node.js or hvigor version have changed and a new daemon will be created to replace the existing daemon. Reason:{isHvigorVersionChanged: ${r}, isNodeEnvChanged: ${t}}`),this.killOldProcessAndCreateNew(o,"stopped by hvigor, runtime has changed.")):o}async killOldProcessAndCreateNew(e,o){return daemon_client_registry_js_1.defaultDaemonClientRegistry.updateDaemonProcessState(e,daemon_info_js_1.DaemonState.STOPPED,o),this.createNewIdleDaemon()}async createNewIdleDaemon(e=!0){log.info("hvigor client: Starting hvigor daemon.");const o=process_1.default.hrtime();let r;const t=(0,crypto_1.randomBytes)(32).toString("hex"),i=session_id_js_1.SessionIdHelper.encryptPwdByDefaultMaterial(t,log),n=(0,child_process_1.fork)(path_1.default.resolve(__dirname,"daemon-process-boot-script.js"),[log.getLevel().toString(),i],{stdio:["pipe","pipe","pipe","ipc"],detached:!0,env:{...process_1.default.env,_logLevel:log.getLevel().toString(),_sessionId:i},execArgv:this.childExecArgv});let s;return this.createDaemonPromise=new Promise((e=>{n.once("message",(t=>{t.startsWith(daemon_const_js_1.DAEMON_LISTEN_FAILED_REASON_PREFIX)?(log.warn(`hvigor client: daemon failed to listen on the port. Build will be started in no-daemon mode. Reason: ${t}`),r=void 0):(r=JSON.parse(t),log.info(`Hvigor Daemon started in ${(0,pretty_hrtime_js_1.default)(process_1.default.hrtime(o))}`),log.debug(`A new daemon has been created successfully and is listening for requests, daemonInfo=${t}`)),e()})),s=setTimeout((()=>{n.off("message",(()=>{log.warn("hvigor client: Failed to start hvigor daemon. The build will be started in no-daemon mode."),n.pid?(log.warn("hvigor client: This should be an error while initializing hvigor daemon."),log.daemonWarnLink(n.pid)):log.warn("hvigor client: This should be an error that hvigor daemon didn't start.")})),e()}),1e4)})),e&&await this.createDaemonPromise,clearTimeout(s),n.unref(),r}calcChildExecArgv(){var e,o;const r=null===(o=null===(e=hvigor_config_reader_js_1.HvigorConfigReader.getHvigorConfig())||void 0===e?void 0:e.nodeOptions)||void 0===o?void 0:o.maxOldSpaceSize,t=process_1.default.execArgv;return r?(t.push(`--max-old-space-size=${r}`),log.debug(`hvigor client: daemon process use hvigor-config.json5 node options: --max-old-space-size=${r}`)):t.length>0?log.debug(`hvigor client: daemon process use parent process execArgv \n         ${process_1.default.execArgv}`):log.debug("hvigor client: daemon process use default node options."),t}createDaemonFork(){this.getProjectCompatibleIdleDaemon(!1)}}exports.DaemonProcessFactory=DaemonProcessFactory,exports.defaultDaemonServerFactory=new DaemonProcessFactory;