"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.DaemonServerListenerRegistry=void 0;const process_1=__importDefault(require("process")),exit_js_1=require("../../boot/hooks/exit.js"),build_event_js_1=require("../../common/daemon-protocol/build-event.js"),common_enum_js_1=require("../../common/daemon-protocol/common-enum.js"),message_js_1=require("../../common/daemon-protocol/message.js"),daemon_const_js_1=require("../const/daemon-const.js"),hvigor_daemon_log_js_1=require("../log/hvigor-daemon-log.js"),daemon_process_lifecycle_js_1=require("../process/daemon-process-lifecycle.js"),daemon_info_js_1=require("../registry/daemon-info.js"),daemon_info_service_js_1=require("../registry/daemon-info-service.js"),daemon_server_registry_js_1=require("../registry/daemon-server-registry.js"),session_manager_js_1=require("../session/session-manager.js"),daemon_server_socket_listener_registry_js_1=require("../socket/daemon-server-socket-listener-registry.js"),print_util_js_1=require("../util/print-util.js"),_log=hvigor_daemon_log_js_1.HvigorDaemonLogger.getLogger("daemon");class DaemonServerListenerRegistry{registryAllListener(e){this.onListening(e),this.onConnection(e),this.onError(e),this.onCloseConnection(e),this.onListenFailed(e),this.onCloseServer(e)}onConnection(e){e.onConnection((async s=>{session_manager_js_1.defaultSessionManager.initSession(s);const o=session_manager_js_1.defaultSessionManager.getLength();if(_log.debug(`hvigor daemon: Socket is connected. socketId=${s.id}, connectionCount=${o}`),o>daemon_const_js_1.DAEMON_SOCKETS_MAX_LIMIT){const e="hvigor daemon：The number of hvigor daemon connections has reached the upper limit, this socket will be disconnect. Please wait for one of the connections to be disconnected and then try again.";s.emit(build_event_js_1.BuildEvent.BUILD_STATUS,(0,message_js_1.createBuildStatus)(common_enum_js_1.BuildStatus.REJECT,-1,e)),s.disconnect(!0)}new daemon_server_socket_listener_registry_js_1.DaemonServerSocketListenerRegistry(s).registryBaseListener(e),_log.debug(`hvigor daemon: daemonState=${(0,daemon_process_lifecycle_js_1.getCurrentProcessState)()} \n      daemonInfo=${JSON.stringify(daemon_server_registry_js_1.defaultDaemonServerRegistry.getInfos())}`),(0,daemon_process_lifecycle_js_1.getCurrentProcessState)()!==daemon_info_js_1.DaemonState.IDLE&&(0,daemon_process_lifecycle_js_1.getCurrentProcessState)()!==daemon_info_js_1.DaemonState.CANCELED||(0,daemon_process_lifecycle_js_1.setCurrentProcessState)(daemon_info_js_1.DaemonState.HALF_BUSY)}))}onCloseConnection(e){e.onCloseConnection((async e=>{var s;e.id===(null===(s=session_manager_js_1.defaultSessionManager.getActiveSocket())||void 0===s?void 0:s.id)&&session_manager_js_1.defaultSessionManager.resetActiveSocket(),session_manager_js_1.defaultSessionManager.endSession(e);const o=session_manager_js_1.defaultSessionManager.getSockets().length;_log.debug(`hvigor daemon: Socket will be closed. socketId=${e.id}, connectionCount=${o}`),0===o&&(0,daemon_process_lifecycle_js_1.getCurrentProcessState)()===daemon_info_js_1.DaemonState.HALF_BUSY&&(0,daemon_process_lifecycle_js_1.setCurrentProcessState)(daemon_info_js_1.DaemonState.IDLE)}))}onCloseServer(e){e.onCloseServer((e=>{_log.debug(`hvigor daemon: connectionCount=${session_manager_js_1.defaultSessionManager.getLength()}`),e&&(_log.error(`hvigor daemon: ${e}`),e.stack&&_log.error(e.stack)),[...session_manager_js_1.defaultSessionManager.getSockets()].forEach((s=>{s.emit(build_event_js_1.BuildEvent.OUTPUT,e.stack),s.emit(common_enum_js_1.BuildStatus.CLOSE,(0,message_js_1.createBuildStatus)(common_enum_js_1.BuildStatus.CLOSE,0))}))}))}onError(e){e.onError((e=>{_log.error(`Server error: ${e.message}`),(0,exit_js_1.exit)(-1)}))}onListening(e){e.onListening((()=>{const s=e.getHttpServer().address();_log.debug(`hvigor daemon: listening connection. address=${s.address}, port=${s.port}.`);const o=daemon_info_service_js_1.defaultDaemonInfoService.createDefaultDaemonInfo(s,e.getSessionId());daemon_server_registry_js_1.defaultDaemonServerRegistry.setInfo(o.keyId,o),void 0!==process_1.default.send&&process_1.default.send(JSON.stringify(o)),(0,print_util_js_1.overridePrintWrite)()}))}onListenFailed(e){e.onListenFailed((e=>{void 0!==process_1.default.send&&process_1.default.send(`${daemon_const_js_1.DAEMON_LISTEN_FAILED_REASON_PREFIX}${e}`)}))}}exports.DaemonServerListenerRegistry=DaemonServerListenerRegistry;