"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.DefaultFilesystemSnapshotGenerator=void 0;const directory_snapshot_js_1=require("../core/directory-snapshot.js"),file_snapshot_js_1=require("../core/file-snapshot.js"),file_hasher_js_1=require("../util/file-hasher.js"),file_metadata_js_1=require("../util/file-metadata.js"),file_tree_js_1=require("../util/file-tree.js"),file_type_js_1=require("../util/file-type.js"),hash_js_1=require("../util/hash.js");class FileVisitorImpl{constructor(e){this.rootSnapShot=void 0,this.stack=[],this.fileHasher=e}preVisitDirectory(e){const t=new directory_snapshot_js_1.DirectorySnapshot(e.name,e.path,e.type,e.isSymbolicLink);if(void 0===this.rootSnapShot&&(this.rootSnapShot=t),this.stack.length>0){this.stack[this.stack.length-1].children.push(t)}this.stack.push(t)}visitFile(e){const t=new file_metadata_js_1.FileMetaData(e.size,e.lastModifiedTime),s=new file_snapshot_js_1.FileSnapshot(e.name,e.path,e.type,e.isSymbolicLink,t);if(s.hashValue=this.fileHasher.hash(e.path,t),void 0===this.rootSnapShot&&(this.rootSnapShot=s),this.stack.length>0){this.stack[this.stack.length-1].children.push(s)}}postVisitDirectory(e){const t=this.stack.pop();if(t&&t.children.length>0){t.children.sort(((e,t)=>e.name.localeCompare(t.name)));let e="";t.children.forEach((t=>{e+=t.name+t.hashValue})),t.hashValue=hash_js_1.Hash.hash(e)}}visitFileFailed(e,t){}}class DefaultFilesystemSnapshotGenerator{constructor(e=new file_hasher_js_1.FileMetaHasher){this.fileHasher=e}parseFileSystemSnapshot(e){var t,s,i,a,o,r,l;const h=e.type,n=null!==(t=e.hashValue)&&void 0!==t?t:"",p=null!==(s=e.name)&&void 0!==s?s:"",_=null!==(i=e.path)&&void 0!==i?i:"",c=null!==(a=e.isSymbolicLink)&&void 0!==a?a:"";if(h===file_type_js_1.FileType.FILE.toString()){const t=new file_metadata_js_1.FileMetaData,s=e.fileMetaData;if(s){const e=null!==(o=s.size)&&void 0!==o?o:0,i=null!==(r=s.lastModifiedTime)&&void 0!==r?r:0;t.size=e,t.lastModifiedTime=i}const i=new file_snapshot_js_1.FileSnapshot(p,_,file_type_js_1.FileType.FILE,c,t);return i.hashValue=n,i}if(h===file_type_js_1.FileType.DIRECTORY.toString()){const t=new directory_snapshot_js_1.DirectorySnapshot(p,_,file_type_js_1.FileType.DIRECTORY,c);t.hashValue=n;const s=null!==(l=e.children)&&void 0!==l?l:[];for(const e of s){const s=this.parseFileSystemSnapshot(e);void 0!==s&&t.children.push(s)}return t}}snapshot(e,t){var s;const i=new FileVisitorImpl(this.fileHasher),a={};return t&&t.test&&(a.filter=t.test),(0,file_tree_js_1.walkFileTree)(e,i,a),null!==(s=i.rootSnapShot)&&void 0!==s?s:new directory_snapshot_js_1.DirectorySnapshot("emptyroot","",file_type_js_1.FileType.UNKNOWN,!1)}loadSnapshotFromJson(e){let t;try{t=JSON.parse(e)}catch(e){return}return this.parseFileSystemSnapshot(t)}loadSnapshotCacheFromJson(e){let t;try{t=JSON.parse(e)}catch(e){return}const s=new Map;return Object.keys(t).forEach((e=>{const i=this.parseFileSystemSnapshot(t[e]);void 0!==i&&s.set(e,i)})),s}serializeSnapshotToJson(e){const t={};return e.forEach(((e,s)=>{t[s]=e})),JSON.stringify(t)}}exports.DefaultFilesystemSnapshotGenerator=DefaultFilesystemSnapshotGenerator;