"use strict";var __createBinding=this&&this.__createBinding||(Object.create?function(t,e,s,a){void 0===a&&(a=s);var i=Object.getOwnPropertyDescriptor(e,s);i&&!("get"in i?!e.__esModule:i.writable||i.configurable)||(i={enumerable:!0,get:function(){return e[s]}}),Object.defineProperty(t,a,i)}:function(t,e,s,a){void 0===a&&(a=s),t[a]=e[s]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(t,e){Object.defineProperty(t,"default",{enumerable:!0,value:e})}:function(t,e){t.default=e}),__importStar=this&&this.__importStar||function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var s in t)"default"!==s&&Object.prototype.hasOwnProperty.call(t,s)&&__createBinding(e,t,s);return __setModuleDefault(e,t),e};Object.defineProperty(exports,"__esModule",{value:!0}),exports.TaskProxy=void 0;const fs=__importStar(require("fs")),hvigor_log_js_1=require("../../../log/hvigor-log.js"),time_util_js_1=require("../../../util/time-util.js"),project_cache_service_js_1=require("../../cache/project-cache-service.js"),cache_util_js_1=require("../../cache/util/cache-util.js"),snapshot_comparator_service_js_1=require("../../snapshot/service/snapshot-comparator-service.js"),snapshot_generator_service_js_1=require("../../snapshot/service/snapshot-generator-service.js"),_log=hvigor_log_js_1.HvigorLogger.getLogger("hvigor-task-proxy");class TaskProxy{constructor(t){this.task=t,this.taskNode=t.getNode(),this.project=this.taskNode.getProject(),this.projectCacheService=project_cache_service_js_1.ProjectCacheService.getInstance(this.project),this.snapshotGeneratorService=snapshot_generator_service_js_1.SnapshotGeneratorService.getInstance(),this.snapshotComparatorService=snapshot_comparator_service_js_1.SnapshotComparatorService.getInstance(),this.cacheTaskSnapShot=this.projectCacheService.getTaskSnapShot(t.getName(),this.taskNode),this.curInputFileSnapShotMap=new Map}isTaskChange(){return this.curTaskSnapShot.updateCacheFilesOptions(this.projectCacheService),void 0!==this.cacheTaskSnapShot&&this.cacheTaskSnapShot.isSuccessful()?!!snapshot_comparator_service_js_1.SnapshotComparatorService.isDiff(this.cacheTaskSnapShot,this.curTaskSnapShot)&&(_log.debug(`${this.task.getPath()} is not up-to-date, since the task snapshots are different.`),this.task.durationEvent.addTaskRunReason("The task snapshots are different."),!0):(_log.debug(`${this.task.getPath()} is not up-to-date, since no history record is available.`),this.task.durationEvent.addTaskRunReason("No history record is available."),!0)}getFileCompareResult(t,e){const s=this.snapshotGeneratorService.generateFileSystemSnapshot(t,e),a=this.projectCacheService.getFileSnapShot(t);return a?[s,snapshot_comparator_service_js_1.SnapshotComparatorService.isDiff(a,s)]:[s,!0]}isTaskInputFilesChange(){var t;const e=this.task.declareInputFiles().collect();for(const[s,a]of e){if(!fs.existsSync(s))throw new Error(`Failed to find the incremental input file: ${s}.`);const e=this.getFileCompareResult(s,a);if(e[1])return null===(t=this.curInputFileSnapShotMap)||void 0===t||t.set(s,e[0]),_log.debug(`${this.task.getPath()} is not up-to-date, since the input file '${s}' has been changed.`),this.task.durationEvent.addTaskRunReason(`The input file '${s}' has been changed.`),!0}return!1}isTaskOutputFilesChange(){const t=this.task.declareOutputFiles().collect();for(const[e,s]of t){if(!fs.existsSync(e))return _log.debug(`${this.task.getPath()} is not up-to-date, since the output file '${e}' does not exist.`),this.task.durationEvent.addTaskRunReason(`The output file '${e}' does not exist.`),!0;if(this.getFileCompareResult(e,s)[1])return _log.debug(`${this.task.getPath()} is not up-to-date, since the output file '${e}' has been changed.`),this.task.durationEvent.addTaskRunReason(`The output file '${e}' has been changed.`),!0}return!1}preExecute(){var t,e;const s=process.hrtime();this.curTaskSnapShot=this.snapshotGeneratorService.generateTaskSnapshot(this.task);null===(t=this.cacheTaskSnapShot)||void 0===t||t.isSuccessful();if(!(null===(e=this.cacheTaskSnapShot)||void 0===e?void 0:e.isSuccessful()))return!1;const a=this.isTaskInputFilesChange();if(a){const t=process.hrtime(s),e=(0,time_util_js_1.formatTime)(t);return _log.debug(`Incremental task ${this.task.getPath()} pre-execution cost: ${e}.`),!1}const i=this.isTaskOutputFilesChange();if(i){const t=process.hrtime(s),e=(0,time_util_js_1.formatTime)(t);return _log.debug(`Incremental task ${this.task.getPath()} pre-execution cost: ${e}.`),!1}const o=!this.isTaskChange()&&!a&&!i,r=process.hrtime(s),n=(0,time_util_js_1.formatTime)(r);return _log.debug(`Incremental task ${this.task.getPath()} pre-execution cost: ${n}.`),o}async execute(){await this.task.execute()}postExecute(){const t=process.hrtime();if(this.task.taskExecutedStatus.isUpToDate())return void _log.debug(`There is no need to refresh cache, since the incremental task ${this.task.getPath()} is up-to-date.`);this.updateTaskInputFilesSnapshot(),this.updateTaskOutputFilesSnapShot(),this.updateTaskSnapShot();const e=process.hrtime(t),s=(0,time_util_js_1.formatTime)(e);_log.debug(`Incremental task ${this.task.getPath()} post-execution cost:${s}.`)}updateTaskOutputFilesSnapShot(){this.task.declareOutputFiles().collect().forEach(((t,e)=>{_log.debug(`Update task ${this.task.getPath()} output file:${e} cache.`);const s=this.snapshotGeneratorService.generateFileSystemSnapshot(e,t);this.projectCacheService.updateFileSnapShot(e,s)}))}updateTaskInputFilesSnapshot(){this.task.declareInputFiles().collect().forEach(((t,e)=>{if(this.curInputFileSnapShotMap.has(e))_log.debug(`Update task ${this.task.getPath()} input file:${e} cache from map.`),this.projectCacheService.updateFileSnapShot(e,this.curInputFileSnapShotMap.get(e));else{_log.debug(`Update task ${this.task.getPath()} input file:${e} cache by regenerate.`);const s=this.snapshotGeneratorService.generateFileSystemSnapshot(e,t);this.projectCacheService.updateFileSnapShot(e,s)}}))}updateTaskSnapShot(){const t=(0,cache_util_js_1.getTaskSnapCacheEntryUniqueKey)(this.task.getName(),this.taskNode);this.curTaskSnapShot||(this.curTaskSnapShot=this.snapshotGeneratorService.generateTaskSnapshot(this.task)),this.curTaskSnapShot.updateFilesOptions(this.projectCacheService),this.projectCacheService.updateTaskSnapShot(t,this.curTaskSnapShot)}getCurTaskSnapShot(){return this.curTaskSnapShot}}exports.TaskProxy=TaskProxy;