/// <reference types="node" />
import { SpawnSyncOptionsWithBufferEncoding } from 'child_process';
/**
 * 通过node原生require.resolve接口方法来判断在指定的paths路径中是否可以找到对应的npm包
 *
 * @param {string} packName npm pack name
 * @param {string[]} nodePaths node paths
 * @returns {boolean} true/false
 */
export declare function hasNpmPackInPaths(packName: string, nodePaths: string[]): boolean;
/**
 * 获取执行当前脚本的node路径中的npm
 *
 * @returns {string}
 */
export declare function getNpmPath(): string;
/**
 * 同步执行命令
 *
 * @param {string} command 命令
 * @param {string[]} parameters 命令参数
 * @param {SpawnSyncOptionsWithBufferEncoding} options 执行配置
 */
export declare function executeCommand(command: string, parameters: string[], options: SpawnSyncOptionsWithBufferEncoding): void;
/**
 * 离线插件包相对路径转换
 *
 * @param {string} basePath 工程路径
 * @param {string} versionOrPath 离线安装包路径，若是版本号则不进行转换
 */
export declare function offlinePluginConversion(basePath: string, versionOrPath: string): string;
/**
 * 判断文件是否存在
 *
 * @param {string} path 文件路径
 * @return {boolean} true/false
 */
export declare function isFileExists(path: string): boolean;
