import { ModulePathInfoIml } from '@ohos/hvigor-ohos-plugin/src/common/iml/module-path-info-iml.js';
import { TargetTaskService } from '@ohos/hvigor-ohos-plugin/src/tasks/service/target-task-service.js';
/**
 * 跨平台处理任务中的路径工具类
 *
 * @since 2022/11/24
 */
export declare class PathInfo {
    private projectDir;
    private readonly moduleName;
    constructor(projectDir: string, isApplication: boolean);
    getArkUIXProjectRootPath(): string;
    /**
     * 获取Android工程assets路径
     *
     * @return {string} android/app/src/main/assets
     */
    getAndroidAssectPath(): string;
    /**
     * 获取Ios工程assets路径
     *
     * @return {string} ios//arkui-x
     */
    getIosAssectPath(): string;
    /**
     * 获取Android工程从ohos工程拷贝的bundle文件存放位置
     *
     * @return {string} android/app/src/main/assets/
     */
    getAndroidAssectModulePath(moduleName: string, targetName: string): string;
    /**
     * 获取Ios工程从ohos工程拷贝的bundle文件存放位置
     *
     * @return {string} ios/app/src/main/assets/
     */
    getIosAssectModulePath(moduleName: string, targetName: string): string;
    /**
     * android ohos模块bundle存放位置
     *
     * @param moduleName
     * @return {string} android/app/src/main/assets/arkui-x/entry/ets
     */
    getAndroidAssectModuleEtsPath(moduleName: string, targetName: string): string;
    /**
     * ios ohos模块bundle存放位置
     *
     * @param moduleName
     * @return {string} ios/app/arkui-x/entry/ets
     */
    getIosAssectModuleEtsPath(moduleName: string, targetName: string): string;
    /**
     * 获取Ios工程build目录
     *
     * @return {string} ios/js
     */
    getIosBuildPath(): string;
    /**
     * 获取Android工程build目录
     *
     * @return {string} ios/js
     */
    getAndroidBuildPath(): string;
    /**
     * 获取native工程Android工程侧编译生成的.cxx产物目录
     *
     * @return {string} .cxx生成产物的路径
     */
    getAndroidCxxPath(): string;
    /**
     * 获取Ios工程跨平台资源存放路径
     *
     * @return {string} ios/js
     */
    getIosResPath(): string;
    /**
     * 获取Ios工程跨平台系统资源存放路径
     *
     * @return {string} ios/arkui-x/systemres
     */
    getIosSystemResPath(): string;
    /**
     * 获取Android工程跨平台系统资源存放路径
     *
     * @return {string} android/app/src/main/assets/res/systemres
     */
    getAndroidSystemResPath(): string;
    /**
     * 获取Android工程根路径
     *
     * @return {string} android
     */
    getAndroidProjectDir(): string;
    /**
     * 获取Ios工程根路径
     *
     * @return {string} android
     */
    getIosProjectDir(): string;
    /**
     * 获取Ios etsapp.xcodeproj路径
     *
     * @return {string} ios/etsapp.xcodeproj
     */
    getIosXcodeprojDir(): string;
    getIosPbxProjPath(): string;
    /**
     * 获取Android工程libs存放路径
     *
     * @return {string} android/app/libs
     */
    getAndroidLibsPath(): string;
    /**
     * 获取Android工程libs/arm64-v8a路径
     *
     * @return {string} android/app/libs/arm64-v8a
     */
    getAndroidArm64V8aPath(): string;
    getAndroidArmeabiV7aPath(): string;
    /**
     * 获取Ios工程frameworks存放路径
     *
     * @return {string} ios/frameworks
     */
    getIosFrameworksPath(): string;
    getOhosModuleBuildCacheWithBuildModePath(targetService: TargetTaskService, pathInfo: ModulePathInfoIml): string;
    getOhosBundlePath(pathInfo: ModulePathInfoIml): string;
    /**
     * 获取模块使用的Api描述文件
     *
     * @param {TargetTaskService} targetService
     * @param {ModulePathInfoIml} pathInfo
     * @return {string} ohos模块依赖的Api描述文件
     * build\default\cache\target2\target2@CompileArkTS\esmodule\debug\module_collection.json
     */
    getOhosModuleCollectionJsonPath(targetService: TargetTaskService, pathInfo: ModulePathInfoIml): string;
    /**
     * 获取模块使用的component描述文件
     *
     * @param {TargetTaskService} targetService
     * @param {ModulePathInfoIml} pathInfo
     * @return {string} ohos模块依赖的component描述文件
     */
    getOhosComponentCollectionPath(targetService: TargetTaskService, pathInfo: ModulePathInfoIml): string;
    getOhosModuleSdkApiMappingJsonPath(targetService: TargetTaskService, pathInfo: ModulePathInfoIml): string;
    getOhosComponentSdkApiMappingJsonPath(targetService: TargetTaskService, pathInfo: ModulePathInfoIml): string;
    getArkUIXConfigJsonPath(): string;
}
