# 阿里云鸿蒙视频播放器Demo / Aliyun HarmonyOS Next Demo（ArkTS）

## 简介
- 基于华为鸿蒙生态的ArkTs语言开发，为实现音视频播放功能提供参考。
- 底层播放能力依赖Aliyun提供的HarmonyOS Next播放器SDK。
- 本Demo覆盖音视频播放常见场景，包括视频UI、多实例播放、列表播放等。帮助您快速了解、熟悉集成Aliyun HarmonyOS Next 播放器SDK。

## 开发准备

- [鸿蒙HarmonyOS Next](https://developer.huawei.com/consumer/cn/) 本Demo与播放器SDK，仅适用于最新的鸿蒙原生应用生态。开发者需已申请华为开发者账号以及相关IDE、调试设备。
- [ArkTS](https://developer.huawei.com/consumer/cn/doc/harmonyos-references-V5/arkts-arkts-V5)：鸿蒙原生应用基于ArkTS语言开发，请先参考学习ArkTS声明式开发范式。
- [XComponent](https://developer.huawei.com/consumer/cn/doc/harmonyos-guides-V5/arkts-common-components-xcomponent-V5)：可用于EGL/OpenGLES和媒体数据写入，Aliyun播放器基于XComponent能力实现视频渲染，XComponent是核心组件。
- [华为issue提单地址](https://issuereporter.developer.huawei.com/my-created)：如遇到鸿蒙系统能力相关的咨询、问题和诉求，可以在此提单跟踪。

## 目录结构
- 目录核心部分为"AliPlayerDemo/amdemos-player-ohos-listapp/"，此处为Demo的总入口，也是编译入口目录。
- AliPlayerDemo为外层壳工程，主要用于项目编译选项配置（鸿蒙API版本等）、华为账户签名配置。
- 详细设计可参考"amdemos-player-ohos-listapp/"目录下的README.md介绍。目录关键结构如下：
```
|- AliplayerHarmonyOSNextDemo  
|     |-- amdemos-player-ohos-listapp # demo目录
|            |--- libs # 依赖库文件（播放器SDK、RTS lib）
|            |--- src # 源代码
|                  |---- main # 代码目录
|                          |----- ets # 业务代码
|                                  |------ common        # 公共常量、Utils类
|                                  |------ controller    # 业务方法、类
|                                  |------ entryability  # 鸿蒙原生应用入口
|                                  |------ pages         # 业务页面(UI)
|                                  |------ view          # 业务组件(UI)
|                          |----- resources # 资源、页面列表、多语言
|                          |----- module.json5 # 编译配置（设备权限、运行入口配置）
|            |--- README.md # DEMO详解 & 视频场景的最佳实践介绍
```

## DEMO运行&SDK引入
1. 请使用鸿蒙IDE：DevEco Studio NEXT （推荐版本5.0.3.402及后续稳定版本）
2. 部署方式 
 - 如果您希望基于本地的已有项目，仅想参考最佳实践方案和引入SDK的方法。请按步骤3中描述，配置并更新已有项目。
 - 如果您希望直接使用Demo项目运行，可跳过步骤3，参考步骤4、5，使用Demo直接运行。
3. 配置本地项目，引入SDK：
- 在项目中建立'libs'目录，并按如下结构引入ALIYUN播放器SDK及其相关依赖（如需使用RTS直播功能，请务必添加RTS依赖库并引入）。
```
|- your-project # 项目目录
|    |-- libs # 依赖库文件（播放器SDK、RTS lib）
|         |--- premierlibrary.har # 播放器SDK
|         |--- artclibrary.har # RTS库
|         |--- RtsSDK-release.har # RTS SDK
|    |-- src # 代码目录
```
- 在您的启动目录（本Demo中为'amdemos-player-ohos-listapp'）下，oh-package.json5文件中，配置依赖为如下（完成配置后点击右上角`Sync Now`操作）：
```
"dependencies": {
    "premierlibrary": "file:./libs/premierlibrary.har",
    "artclibrary": "file:./libs/artclibrary.har",
    "RTS": "file:./libs/RtsSDK-release.har",
}
```
- 在您的启动目录（本Demo中为'amdemos-player-ohos-listapp'）下，src/main/module.json5中配置如下权限,允许SDK进行网络请求与后台播放：

```
"requestPermissions": [
  {
    "name": "ohos.permission.INTERNET",
  },
  {
    "name": "ohos.permission.KEEP_BACKGROUND_RUNNING"
  }
],
```
4. 打开并运行DEMO
 - IDE主界面选择 `Open` ，在文件系统中浏览本地文件目录，进入本Demo所在位置
 - 选择目录名称：`AliplayerHarmonyOSNextDemo`后，点击`Open`。
 - 打开Demo项目后，请耐心等待IDE进行初始化和同步。
5. 修改项目签名&运行
 - 请通过IDE右上方登录功能，登录华为开发者账号。点击`Sign in`后跳转外部网站，登录完成后返回IDE。 
 - 修改签名。在IDE左上方，点击`File` -> `Project Structure...` -> `Project` -> `Signing Config` -> 勾选 `Automatically generate signature`。如果已经登录会自动进行签名，完成后即可运行Demo。
 - 连接调试机，点击`运行`按钮。首次build耗时会比较久，请耐心等待。

## 最佳实践解析（Demo代码详解）

最佳实践具体说明，请参阅此目录'amdemos-player-ohos-listapp/README.md'文件. [最佳实践](./amdemos-player-ohos-listapp/README.md)
