import { LiveTimeUpdater } from "../liveshift/LiveTimeUpdater";
import { AVPBase } from "./AVPBase";
import { OhosSaasPlayer } from "./nativeclass/OhosSaasPlayer";
import { UrlSource } from "./source/UrlSource";
import url from "@ohos.url";
import { prepared, started } from "../player/IPlayer";
const onTimeShiftUpdaterListenerMap = new WeakMap();
const liveOnPreparedListenerMap = new WeakMap();
const liveOnLoadingStatusListenerMap = new WeakMap();
const liveOnStateChangedListenerMap = new WeakMap();
export class ApsaraLiveShiftPlayer extends AVPBase {
    constructor(w10, x10) {
        super(w10, x10);
        this.status = -1;
        this.statusWhenSeek = -1;
        this.liveSeekToTime = -1;
        this.liveSeekOffset = -1;
        this.mLiveShiftSource = null;
        this.mLiveTimeUpdater = null;
        this.mOutOnTimeShiftUpdaterListener = null;
        this.mInnerOnTimeShiftUpdaterListener = new InnerTimeShiftUpdateListener(this);
        this.mOutLiveOnPreparedListener = null;
        this.mInnerLiveOnPreparedListener = new InnerLivePreparedListener(this);
        this.mOutLiveOnStateChangedListener = null;
        this.mInnerLiveOnStateChangedListener = new InnerLiveStateChangedListener(this);
        this.mOutLiveOnLoadingStatusListener = null;
        this.mInnerLiveOnLoadingStatusListener = new InnerLiveLoadingStatusListener(this);
        this.mOutLiveSeekLiveCompletionListener = null;
        onTimeShiftUpdaterListenerMap.set(this, this.mInnerOnTimeShiftUpdaterListener);
        liveOnPreparedListenerMap.set(this, this.mInnerLiveOnPreparedListener);
        liveOnLoadingStatusListenerMap.set(this, this.mInnerLiveOnLoadingStatusListener);
        liveOnStateChangedListenerMap.set(this, this.mInnerLiveOnStateChangedListener);
    }
    createAlivcMediaPlayer(u10) {
        let v10 = new OhosSaasPlayer(u10);
        return v10;
    }
    setLiveShiftDataSource(r10) {
        this.mLiveShiftSource = r10;
        let s10 = new UrlSource();
        s10.setUri(this.mLiveShiftSource.getUrl());
        let t10 = this.getCorePlayer();
        if (t10 instanceof OhosSaasPlayer) {
            t10.setUrlDataSource(s10);
        }
    }
    getCurrentLiveTime() {
        if (this.mLiveTimeUpdater) {
            return this.mLiveTimeUpdater.getLiveTime();
        }
        return 0;
    }
    getCurrentTime() {
        if (this.mLiveTimeUpdater) {
            return this.mLiveTimeUpdater.getPlayTime();
        }
        return 0;
    }
    seekToLiveTime(j10) {
        if (this.status == ApsaraLiveShiftPlayer.SeekLive) {
            return;
        }
        if (this.mLiveShiftSource == null) {
            return;
        }
        this.statusWhenSeek = this.status;
        this.status = ApsaraLiveShiftPlayer.SeekLive;
        this.liveSeekToTime = j10;
        this.liveSeekOffset = this.getCurrentLiveTime() - this.liveSeekToTime;
        if (this.liveSeekToTime < 0) {
            this.liveSeekToTime = 0;
            this.liveSeekToTime = this.getCurrentLiveTime();
        }
        let k10 = this.mLiveShiftSource?.getUrl();
        if (this.liveSeekToTime > 0 && this.liveSeekOffset > 0) {
            let l10 = url.URL.parseURL(k10);
            let m10 = new url.URLParams(l10.search);
            let n10 = m10.entries();
            let o10 = Array.from(n10);
            if (k10.endsWith("?") || k10.endsWith("&")) {
                k10 += ("lhs_offset_unix_s_0=" + this.liveSeekOffset + "&lhs_start=1&aliyunols=on");
            }
            else {
                if (o10.length <= 0) {
                    k10 += ("?lhs_offset_unix_s_0=" + this.liveSeekOffset + "&lhs_start=1&aliyunols=on");
                }
                else {
                    k10 += ("&lhs_offset_unix_s_0=" + this.liveSeekOffset + "&lhs_start=1&aliyunols=on");
                }
            }
            let p10 = new UrlSource();
            p10.setUri(k10);
            let q10 = this.getCorePlayer();
            if (q10 instanceof OhosSaasPlayer) {
                q10.setUrlDataSource(p10);
                q10.prepare();
            }
        }
    }
    start() {
        super.start();
        if (this.mLiveTimeUpdater != null) {
            this.mLiveTimeUpdater.resumeUpdater();
        }
    }
    pause() {
        super.pause();
        this.mLiveTimeUpdater?.pauseUpdater();
    }
    stop() {
        super.stop();
        this.mLiveTimeUpdater?.stopUpdater();
    }
    onUpdater(g10, h10, i10) {
        console.info(ApsaraLiveShiftPlayer.tag + `onUpdater, currentTime: ${g10}, shiftStartTime: ${h10}, shiftEndTime: ${i10}`);
        if (this.mOutOnTimeShiftUpdaterListener) {
            this.mOutOnTimeShiftUpdaterListener.onUpdater(g10, h10, i10);
        }
    }
    onPrepared() {
        console.info(ApsaraLiveShiftPlayer.tag + " onPrepared");
        if (this.mLiveTimeUpdater != null) {
            this.mLiveTimeUpdater.stopUpdater();
        }
        else {
            if (this.mLiveShiftSource) {
                this.mLiveTimeUpdater = new LiveTimeUpdater(this.mLiveShiftSource);
                this.mLiveTimeUpdater.setUpdaterListener(this.mInnerOnTimeShiftUpdaterListener);
            }
        }
        let f10 = this.getConfig();
        if (f10 != undefined) {
            this.mLiveTimeUpdater?.setConfig(f10);
            this.mLiveTimeUpdater?.setStartPlayTime(this.liveSeekToTime);
            this.mLiveTimeUpdater?.startUpdater();
        }
        if (this.status == ApsaraLiveShiftPlayer.SeekLive) {
            this.status = prepared;
            if (this.status == started) {
                this.start();
            }
            else {
                if (this.isAutoPlay()) {
                    this.mLiveTimeUpdater?.resumeUpdater();
                }
                else {
                    this.mLiveTimeUpdater?.pauseUpdater();
                }
            }
            if (this.mOutLiveSeekLiveCompletionListener != null) {
                console.info(ApsaraLiveShiftPlayer.tag + ` onSeekLiveCompletion, playTime: ${this.liveSeekToTime}`);
                this.mOutLiveSeekLiveCompletionListener.onSeekLiveCompletion(this.liveSeekToTime);
            }
            this.liveSeekToTime = -1;
        }
        else {
            this.status = prepared;
            if (this.mOutLiveOnPreparedListener != null) {
                this.mOutLiveOnPreparedListener.onPrepared();
            }
        }
    }
    onStateChanged(e10) {
        console.info(ApsaraLiveShiftPlayer.tag + " onStateChanged, newState: " + e10);
        if (e10 != prepared) {
            this.status = e10;
        }
        if (this.mOutLiveOnStateChangedListener != null) {
            this.mOutLiveOnStateChangedListener.onStateChanged(e10);
        }
    }
    onLoadingBegin() {
        console.info(ApsaraLiveShiftPlayer.tag + " onLoadingBegin");
        if (this.mLiveTimeUpdater != null) {
            this.mLiveTimeUpdater.pauseUpdater();
        }
        if (this.mOutLiveOnLoadingStatusListener != null) {
            this.mOutLiveOnLoadingStatusListener.onLoadingBegin();
        }
    }
    onLoadingProgress(c10, d10) {
        console.info(ApsaraLiveShiftPlayer.tag + " onLoadingProgress, percent: " + c10);
        if (this.mOutLiveOnLoadingStatusListener != null) {
            this.mOutLiveOnLoadingStatusListener.onLoadingProgress(c10, d10);
        }
    }
    onLoadingEnd() {
        console.info(ApsaraLiveShiftPlayer.tag + " onLoadingEnd");
        if (this.mLiveTimeUpdater != null) {
            this.mLiveTimeUpdater.resumeUpdater();
        }
        if (this.mOutLiveOnLoadingStatusListener != null) {
            this.mOutLiveOnLoadingStatusListener.onLoadingEnd();
        }
    }
    setOnTimeShiftUpdaterListener(b10) {
        this.mOutOnTimeShiftUpdaterListener = b10;
    }
    setOnSeekLiveCompletionListener(a10) {
        this.mOutLiveSeekLiveCompletionListener = a10;
    }
    setOnStateChangedListener(z9) {
        this.mOutLiveOnStateChangedListener = z9;
        super.setOnStateChangedListener(this.mInnerLiveOnStateChangedListener);
    }
    setOnPreparedListener(y9) {
        this.mOutLiveOnPreparedListener = y9;
        super.setOnPreparedListener(this.mInnerLiveOnPreparedListener);
    }
    setOnLoadingStatusListener(x9) {
        this.mOutLiveOnLoadingStatusListener = x9;
        super.setOnLoadingStatusListener(this.mInnerLiveOnLoadingStatusListener);
    }
}
ApsaraLiveShiftPlayer.tag = "ApsaraLiveShiftPlayer";
ApsaraLiveShiftPlayer.SeekLive = 10;
class InnerTimeShiftUpdateListener {
    constructor(w9) {
        this.avPlayerRef = w9;
    }
    onUpdater(t9, u9, v9) {
        console.log(`currentTime: ${t9}}, shiftStartTime: ${u9}, shiftEndTime: ${v9} `);
        if (this.avPlayerRef != null) {
            this.avPlayerRef.onUpdater(t9, u9, v9);
        }
    }
}
class InnerLivePreparedListener {
    constructor(s9) {
        this.avPlayerRef = s9;
    }
    onPrepared() {
        if (this.avPlayerRef != null) {
            this.avPlayerRef.onPrepared();
        }
    }
}
class InnerLiveStateChangedListener {
    constructor(r9) {
        this.avPlayerRef = r9;
    }
    onStateChanged(q9) {
        if (this.avPlayerRef != null) {
            this.avPlayerRef.onStateChanged(q9);
        }
    }
}
class InnerLiveLoadingStatusListener {
    constructor(p9) {
        this.avPlayerRef = p9;
    }
    onLoadingBegin() {
        if (this.avPlayerRef != null) {
            this.avPlayerRef.onLoadingBegin();
        }
    }
    onLoadingProgress(n9, o9) {
        if (this.avPlayerRef != null) {
            this.avPlayerRef.onLoadingProgress(n9, o9);
        }
    }
    onLoadingEnd() {
        if (this.avPlayerRef != null) {
            this.avPlayerRef.onLoadingEnd();
        }
    }
    ;
}
