import premierlibrary from 'libpremierlibrary.so';
import { Log } from '../../utils/Log';
import { Option, AudioStatus, } from '../IPlayer';
import { InfoBean } from '../bean/InfoBean';
import { findInfoCodeByValue, InfoCode } from '../bean/InfoCode';
import { findErrorCodeByValue } from '../bean/PlayerErrorCode';
import { ErrorInfo } from '../bean/ErrorInfo';
import { ObjCreateHelper } from '../../utils/ObjCreateHelper';
import { findNetworkLevelByCode } from './NetworkStats';
const log = new Log('NativePlayerBase');
export class NativePlayerBase {
    setHasListenerCallback(a34) {
        this.mHasListenerCallback = a34;
    }
    hasListener(z33) {
        if (this.mHasListenerCallback != null) {
            return this.mHasListenerCallback.hasListener(z33);
        }
        return false;
    }
    constructor(c30) {
        this.mNativeContext = BigInt(0);
        this.objHelper = new ObjCreateHelper();
        this.mHasListenerCallback = null;
        this.getNativeContext = () => {
            log.info(`getNativeContext, address: ${this.mNativeContext}`);
            return this.mNativeContext;
        };
        this.setNativeContext = (y33) => {
            log.info(`[addr check] setNativeContext, address: ${y33}`);
            this.mNativeContext = y33;
        };
        this.getHelper = () => {
            log.info(`getHelper`);
            return this.objHelper;
        };
        this.getContext = () => {
            log.info(`[addr check] getNativeContext, address: ${this.mNativeContext}`);
            return this.mContext;
        };
        this.onPrepared = () => {
            console.log('onPrepared called at nativePlayerBase.');
            if (this.mOnPreparedListener != null) {
                this.setOption('InOnPrepared', '1');
                this.mOnPreparedListener.onPrepared();
                this.setOption('InOnPrepared', '0');
            }
        };
        this.onCircleStart = () => {
            if (this.mOnInfoListener != null) {
                let x33 = new InfoBean();
                x33.setCode(InfoCode.LoopingStart);
                this.mOnInfoListener.onInfo(x33);
            }
        };
        this.onAutoPlayStart = () => {
            if (this.mOnInfoListener != null) {
                let w33 = new InfoBean();
                w33.setCode(InfoCode.AutoPlayStart);
                this.mOnInfoListener.onInfo(w33);
            }
        };
        this.onEvent = (s33, t33) => {
            if (this.mOnInfoListener != null) {
                let u33 = findInfoCodeByValue(s33);
                let v33 = new InfoBean();
                v33.setCode(u33);
                v33.setExtraMsg(t33);
                this.mOnInfoListener.onInfo(v33);
            }
        };
        this.onCurrentDownloadSpeed = (q33) => {
            if (this.mOnInfoListener != null) {
                let r33 = new InfoBean();
                r33.setCode(InfoCode.CurrentDownloadSpeed);
                r33.setExtraValue(q33);
                this.mOnInfoListener.onInfo(r33);
            }
        };
        this.onUtcTimeUpdate = (o33) => {
            if (this.mOnInfoListener != null) {
                let p33 = new InfoBean();
                p33.setCode(InfoCode.UtcTime);
                p33.setExtraValue(o33);
                this.mOnInfoListener.onInfo(p33);
            }
        };
        this.onLocalCacheLoad = (m33) => {
            if (this.mOnInfoListener != null) {
                let n33 = new InfoBean();
                n33.setCode(InfoCode.LocalCacheLoaded);
                n33.setExtraValue(m33);
                this.mOnInfoListener.onInfo(n33);
            }
        };
        this.onBufferedPositionUpdate = (k33) => {
            if (this.mOnInfoListener != null) {
                let l33 = new InfoBean();
                l33.setCode(InfoCode.BufferedPosition);
                l33.setExtraValue(k33);
                this.mOnInfoListener.onInfo(l33);
            }
        };
        this.onCurrentPositionUpdate = (i33) => {
            if (this.mOnInfoListener != null) {
                let j33 = new InfoBean();
                j33.setCode(InfoCode.CurrentPosition);
                j33.setExtraValue(i33);
                this.mOnInfoListener.onInfo(j33);
            }
        };
        this.onFirstFrameShow = () => {
            if (this.mOnRenderingStartListener != null) {
                this.mOnRenderingStartListener.onRenderingStart();
            }
        };
        this.onVideoSizeChanged = (g33, h33) => {
            if (this.mOnVideoSizeChangedListener != null) {
                this.mOnVideoSizeChangedListener.onVideoSizeChanged(g33, h33);
            }
        };
        this.onAudioInterruptEvent = (f33) => {
            if (this.mOnAudioInterruptEventListener != null) {
                if (f33 < AudioStatus.AUDIO_STATUS_DEFAULT || f33 > AudioStatus.AUDIO_STATUS_UNDUCK) {
                    log.info('onAudioInterruptEvent exception audioStatus: ' + f33);
                    this.mOnAudioInterruptEventListener.onAudioInterruptEvent(AudioStatus.AUDIO_STATUS_DEFAULT);
                    return;
                }
                this.mOnAudioInterruptEventListener.onAudioInterruptEvent(f33);
            }
        };
        this.onLoadingStart = () => {
            if (this.mOnLoadingStatusListener != null) {
                this.mOnLoadingStatusListener.onLoadingBegin();
            }
        };
        this.onLoadingProgress = (e33) => {
            if (this.mOnLoadingStatusListener != null) {
                this.mOnLoadingStatusListener.onLoadingProgress(e33, 0);
            }
        };
        this.onLoadingEnd = () => {
            if (this.mOnLoadingStatusListener != null) {
                this.mOnLoadingStatusListener.onLoadingEnd();
            }
        };
        this.onAVNotSyncStart = (d33) => {
            if (this.mOnAVNotSyncStatusListener != null) {
                this.mOnAVNotSyncStatusListener.onAVNotSyncStart(d33);
            }
        };
        this.onAVNotSyncEnd = (c33) => {
            if (this.mOnAVNotSyncStatusListener != null) {
                this.mOnAVNotSyncStatusListener.onAVNotSyncEnd();
            }
        };
        this.onNetworkStats = (z32, a33) => {
            let b33 = findNetworkLevelByCode(a33);
            z32.networkLevel = b33;
            if (this.mOnNetworkStatsListener != null) {
                this.mOnNetworkStatsListener.onNetworkStats(z32);
            }
        };
        this.onSeekEnd = () => {
            if (this.mOnSeekCompleteListener != null) {
                this.mOnSeekCompleteListener.onSeekComplete();
            }
        };
        this.onStatusChanged = (x32, y32) => {
            log.info('onStatusChanged, newState: ' + x32 + ' oldState: ' + y32);
            if (this.mOnStateChangedListener != null) {
                this.mOnStateChangedListener.onStateChanged(x32);
            }
        };
        this.onCompletion = () => {
            if (this.mOnCompletionListener != null) {
                this.mOnCompletionListener.onCompletion();
            }
        };
        this.onVideoRendered = (v32, w32) => {
            if (this.mOnVideoRenderedListener != null) {
                this.mOnVideoRenderedListener.onVideoRendered(v32, w32);
            }
        };
        this.onShowSubtitle = (s32, t32, u32) => {
            if (this.mOnSubtitleDisplayListener != null) {
                this.mOnSubtitleDisplayListener.onSubtitleShow(s32, t32, u32);
            }
        };
        this.onSubtitleExtAdded = (q32, r32) => {
            if (this.mOnSubtitleDisplayListener != null) {
                this.mOnSubtitleDisplayListener.onSubtitleExtAdded(q32, r32);
            }
        };
        this.onHideSubtitle = (o32, p32) => {
            if (this.mOnSubtitleDisplayListener != null) {
                this.mOnSubtitleDisplayListener.onSubtitleHide(o32, p32);
            }
        };
        this.onSubtitleHeader = (m32, n32) => {
            if (this.mOnSubtitleDisplayListener != null) {
                this.mOnSubtitleDisplayListener.onSubtitleHeader(m32, n32);
            }
        };
        this.onError = (h32, i32, j32) => {
            let k32 = findErrorCodeByValue(h32);
            if (this.mOnErrorListener != null) {
                let l32 = new ErrorInfo();
                l32.setCode(k32);
                l32.setMsg(i32);
                l32.setExtra(j32);
                this.mOnErrorListener.onError(l32);
            }
        };
        this.onSubtitleExtAddedError = (e32, f32) => {
            if (this.mOnInfoListener != null) {
                let g32 = new InfoBean();
                g32.setCode(InfoCode.SubtitleSelectError);
                g32.setExtraValue(e32);
                g32.setExtraMsg(f32);
                this.mOnInfoListener.onInfo(g32);
            }
        };
        this.onUrlExpired = (d32) => {
            if (this.mOnUrlExpiredListener != null) {
                this.mOnUrlExpiredListener.onUrlExpired(d32, null);
            }
        };
        this.onStreamSwitchSuc = (c32) => {
            if (this.mOnTrackChangedListener != null) {
                this.mOnTrackChangedListener.onChangedSuccess(c32);
            }
        };
        this.onStreamInfoGet = (b32) => {
            if (this.mOnTrackReadyListener != null) {
                this.mOnTrackReadyListener.onTrackReady(b32);
            }
        };
        this.onSubStreamInfoGet = (a32) => {
            if (this.mOnSubTrackReadyListener != null) {
                this.mOnSubTrackReadyListener.onSubTrackReady(a32);
            }
        };
        this.onSwitchStreamUrlResult = (v31, w31, x31) => {
            if (this.mOnStreamSwitchedListener == null) {
                return;
            }
            if (w31 == 0) {
                this.mOnStreamSwitchedListener.onSwitchedSuccess(v31);
            }
            else {
                let y31 = findErrorCodeByValue(w31);
                let z31 = new ErrorInfo();
                z31.setCode(y31);
                z31.setMsg(x31);
                this.mOnStreamSwitchedListener.onSwitchedFail(v31, z31);
            }
        };
        this.onCaptureScreen = (s31, t31, u31) => {
            if (this.mOnSnapShotListener != null) {
                this.mOnSnapShotListener.onSnapShot(u31, s31, t31);
            }
        };
        this.onSeiDataCallback = (q31, r31) => {
            if (this.mOnSeiDataListener != null) {
                this.mOnSeiDataListener.onSeiData(q31, new Uint8Array(r31));
            }
        };
        log.info('constructor_');
        this.mContext = c30;
        premierlibrary.nConstruct(this);
    }
    setOnPreparedListener(b30) {
        this.mOnPreparedListener = b30;
    }
    setOnInfoListener(a30) {
        this.mOnInfoListener = a30;
    }
    setOnRenderingStartListener(z29) {
        this.mOnRenderingStartListener = z29;
    }
    setOnStateChangedListener(y29) {
        this.mOnStateChangedListener = y29;
    }
    setOnCompletionListener(x29) {
        this.mOnCompletionListener = x29;
    }
    setOnLoadingStatusListener(w29) {
        this.mOnLoadingStatusListener = w29;
    }
    setOnErrorListener(v29) {
        this.mOnErrorListener = v29;
    }
    setOnVideoSizeChangedListener(u29) {
        this.mOnVideoSizeChangedListener = u29;
    }
    setOnSeekCompleteListener(t29) {
        this.mOnSeekCompleteListener = t29;
    }
    setOnSubtitleDisplayListener(s29) {
        this.mOnSubtitleDisplayListener = s29;
    }
    setOnUrlExpiredListener(r29) {
        this.mOnUrlExpiredListener = r29;
    }
    setOnVideoRenderedListener(q29) {
        this.mOnVideoRenderedListener = q29;
    }
    setOnAudioInterruptEventListener(p29) {
        this.mOnAudioInterruptEventListener = p29;
    }
    setOnTrackReadyListener(o29) {
        this.mOnTrackReadyListener = o29;
    }
    setOnSubTrackReadyListener(n29) {
        this.mOnSubTrackReadyListener = n29;
    }
    setOnStreamSwitchedListener(m29) {
        this.mOnStreamSwitchedListener = m29;
    }
    setOnAVNotSyncStatusListener(l29) {
        this.mOnAVNotSyncStatusListener = l29;
    }
    setOnNetworkStatsListener(k29) {
        this.mOnNetworkStatsListener = k29;
    }
    setOnTrackChangedListener(j29) {
        this.mOnTrackChangedListener = j29;
    }
    setOnSnapShotListener(i29) {
        this.mOnSnapShotListener = i29;
    }
    setOnSeiDataListener(h29) {
        this.mOnSeiDataListener = h29;
    }
    start() {
        log.info('nStart');
        premierlibrary.nStart(this);
    }
    pause() {
        log.info('nPause');
        premierlibrary.nPause(this);
    }
    stop() {
        log.info('nStop');
        premierlibrary.nStop(this);
    }
    prepare() {
        log.info('nPrepare');
        premierlibrary.nPrepare(this);
    }
    setAutoPlay(g29) {
        log.info('nSetAutoPlay');
        premierlibrary.nSetAutoPlay(this, g29);
    }
    setSurfaceId(f29) {
        log.info('nSetSurfaceId');
        premierlibrary.nSetSurfaceId(this, f29);
    }
    setSpeed(e29) {
        log.info('setSpeed');
        premierlibrary.nSetSpeed(this, e29);
    }
    switchStream(d29) {
        log.info('switchStream');
        premierlibrary.nSwitchStream(this, d29);
    }
    setAlphaRenderMode(c29) {
        log.info('setAlphaRenderMode');
        premierlibrary.nSetAlphaRenderMode(this, c29);
    }
    getAlphaRenderMode() {
        log.info('getAlphaRenderMode');
        return premierlibrary.nGetAlphaRenderMode(this);
    }
    selectTrack(b29) {
        log.info('selectTrack');
        premierlibrary.nSelectTrack(this, b29);
    }
    getCurrentTrack(z28) {
        log.info('getCurrentTrack, type: ' + z28);
        let a29 = premierlibrary.nGetCurrentStreamInfo(this, z28);
        return a29;
    }
    addExtSubtitle(y28) {
        log.info(`addExtSubtitle`);
        premierlibrary.nAddExtSubtitle(this, y28);
    }
    selectExtSubtitle(w28, x28) {
        log.info(`selectExtSubtitle`);
        premierlibrary.nSelectExtSubtitle(this, w28, x28);
    }
    setVolume(v28) {
        log.info('setVolume');
        premierlibrary.nSetVolume(this, v28);
    }
    getVolume() {
        log.info('getVolume');
        return premierlibrary.nGetVolume(this);
    }
    seekTo(t28, u28) {
        log.info('seekTo');
        premierlibrary.nSeekTo(this, t28, u28);
    }
    setStartTime(r28, s28) {
        log.info('setStartTime');
        premierlibrary.nSetStartTime(this, r28, s28);
    }
    getDuration() {
        log.info('getDuration');
        return premierlibrary.nGetDuration(this);
    }
    setGlobalTime(q28) {
        premierlibrary.nSetGlobalTime(this, q28);
    }
    getPlayedDuration() {
        log.info('getPlayedDuration');
        return premierlibrary.nGetPlayedDuration(this);
    }
    getCurrentPosition() {
        log.info('getCurrentPosition');
        return premierlibrary.nGetCurrentPosition(this);
    }
    getBufferedPosition() {
        log.info('getBufferedPosition');
        return premierlibrary.nGetBufferedPosition(this);
    }
    getPlayerStatus() {
        log.info('getPlayerStatus');
        return premierlibrary.nGetPlayerStatus(this);
    }
    setTraceId(p28) {
        log.info('setTraceId');
        premierlibrary.nSetTraceId(this, p28);
    }
    enableHardwareDecoder(o28) {
        log.info('enableHardwareDecoder');
        premierlibrary.nEnableHardwareDecoder(this, o28);
    }
    release() {
        log.info('release');
        premierlibrary.nRelease(this);
    }
    setMute(n28) {
        log.info('setMute');
        premierlibrary.nSetMute(this, n28);
    }
    isMuted() {
        log.info('isMuted');
        return premierlibrary.nIsMuted(this) === 1;
    }
    setScaleMode(m28) {
        log.info('setScaleMode');
        premierlibrary.nSetScaleMode(this, m28);
    }
    getScaleMode() {
        log.info('getScaleMode');
        return premierlibrary.nGetScaleMode(this);
    }
    setLoop(l28) {
        log.info('setLoop');
        premierlibrary.nSetLoop(this, l28);
    }
    isLoop() {
        log.info('isLoop');
        return premierlibrary.nIsLoop(this) === 1;
    }
    getVideoWidth() {
        log.info('getVideoWidth');
        return premierlibrary.nGetVideoWidth(this);
    }
    getVideoHeight() {
        log.info('getVideoHeight');
        return premierlibrary.nGetVideoHeight(this);
    }
    getVideoRotation() {
        log.info('getVideoRotation');
        return premierlibrary.nGetVideoRotation(this);
    }
    reload() {
        log.info('reload');
        premierlibrary.nReload(this);
    }
    setRotateMode(k28) {
        log.info('setRotateMode');
        premierlibrary.nSetRotateMode(this, k28);
    }
    getRotateMode() {
        log.info('getRotateMode');
        return premierlibrary.nGetRotateMode(this);
    }
    setMirrorMode(j28) {
        log.info('setMirrorMode');
        premierlibrary.nSetMirrorMode(this, j28);
    }
    getMirrorMode() {
        log.info('getMirrorMode');
        return premierlibrary.nGetMirrorMode(this);
    }
    setVideoBackgroundColor(i28) {
        log.info('setVideoBackgroundColor');
        premierlibrary.nSetVideoBackgroundColor(this, i28);
    }
    getSpeed() {
        log.info('getSpeed');
        return premierlibrary.nGetSpeed(this);
    }
    isAutoPlay() {
        log.info('isAutoPlay');
        return premierlibrary.nIsAutoPlay(this) === 1;
    }
    isAutoBandWidth() {
        log.info('isAutoBandWidth');
        return premierlibrary.nIsAutoBandWidth(this) === 1;
    }
    setAutoBandWidth(h28) {
        log.info('nSetAutoBandWidth');
        premierlibrary.nSetAutoBandWidth(this, h28);
    }
    setConfig(g28) {
        log.info('setConfig');
        premierlibrary.nSetConfig(this, g28);
        this.mPlayerConfig = g28;
    }
    getConfig() {
        log.info('getConfig');
        let f28 = premierlibrary.nGetConfig(this);
        return f28;
    }
    setPlayerScene(e28) {
        log.info('setPlayerScene');
        premierlibrary.nSetPlayerScene(this, e28);
    }
    setOption(c28, d28) {
        log.info('setOption');
        premierlibrary.nSetOption(this, c28, d28);
    }
    getOption(z27) {
        let a28 = premierlibrary.nGetOption(this, z27);
        if (z27 == Option.RenderFPS ||
            z27 == Option.DownloadBitrate ||
            z27 == Option.VideoBitrate ||
            z27 == Option.AudioBitrate) {
            let b28 = parseFloat(a28);
            return b28;
        }
        return a28;
    }
    setStreamDelay(x27, y27) {
        log.info('setStreamDelay');
        premierlibrary.nSetStreamDelay(this, x27, y27);
    }
    setMaxAccurateSeekDelta(w27) {
        log.info('setMaxAccurateSeekDelta');
        premierlibrary.nSetMaxAccurateSeekDelta(this, w27);
    }
    setCacheConfig(v27) {
        log.info('setCacheConfig');
        premierlibrary.nSetCacheConfig(this, v27);
    }
    setIPResolveType(u27) {
        log.info('setIPResolveType');
        premierlibrary.nSetIPResolveType(this, u27);
    }
    setFastStart(t27) {
        log.info('setFastStart');
        premierlibrary.nSetFastStart(this, t27);
    }
    snapShot() {
        log.info('snapShot');
        premierlibrary.nSnapShot(this);
    }
    clearScreen() {
        log.info('clearScreen');
        premierlibrary.nClearScreen(this);
    }
    getSdkVersion() {
        log.info('getSdkVersion');
        return premierlibrary.nGetSdkVersion();
    }
    getCacheFilePathByUrl(s27) {
        log.info('getCacheFilePathByUrl');
        return premierlibrary.nGetCacheFilePathByUrl(this, s27);
    }
    getCacheFilePathByVid(o27, p27, q27, r27) {
        log.info('getCacheFilePathByVid');
        return premierlibrary.nGetCacheFilePathByVid(this, o27, p27, q27, r27);
    }
    getPropertyString(n27) {
        log.info('getPropertyString');
        return premierlibrary.nGetPropertyString(this, n27);
    }
    setDefaultBandWidth(m27) {
        log.info('setDefaultBandWidth');
        premierlibrary.nSetDefaultBandWidth(this, m27);
    }
    setDefaultAudioLanguage(l27) {
        log.info('setDefaultAudioLanguage');
        premierlibrary.nSetDefaultAudioLanguage(this, l27);
    }
    setDefaultResolution(k27) {
        log.info('setDefaultResolution');
        premierlibrary.nSetDefaultResolution(this, k27);
    }
    sendCustomEvent(j27) {
        log.info('sendCustomEvent');
        premierlibrary.nSendCustomEvent(this, j27);
    }
    setVideoTag(i27) {
        log.info('setVideoTag');
        premierlibrary.nSetVideoTag(this, i27);
    }
    setUserData(h27) {
        log.info('setUserData');
        premierlibrary.nSetUserData(this, h27);
    }
    getUserData() {
        log.info('getUserData');
        return premierlibrary.nGetUserData(this);
    }
    refreshPlayerUrl(g27) {
        log.info('refreshPlayerUrl');
        premierlibrary.nRefreshPlayerUrl(this, g27);
    }
    refreshPlayerUrlWithError(f27) {
        log.info('refreshPlayerUrlWithError');
        premierlibrary.nRefreshPlayerUrlWithError(this, f27);
    }
    getNativeContextAddr() {
        return this.mNativeContext;
    }
}
