export var PreloadOptionType;
(function (s38) {
    s38["RESOLUTION"] = "RESOLUTION";
    s38["BANDWIDTH"] = "BANDWIDTH";
    s38["QUALITY"] = "QUALITY";
    s38["NONE"] = "NONE";
})(PreloadOptionType || (PreloadOptionType = {}));
export class PreloadConfig {
    constructor(f38) {
        this.mPreloadDuration = 1000;
        this.mLoadStartPositionMs = 0;
        this.mNetworkTimeout = 15000;
        this.mNetworkRetryCount = 2;
        this.mReferrer = '';
        this.mCustomHeaders = [];
        this.mOptionType = PreloadOptionType.NONE;
        this.mOptionIntValue = 0;
        this.mOptionStringValue = '';
        this.nativeGetDefaultBandWidth = () => {
            let r38 = this.getDefaultBandWidth();
            return r38;
        };
        this.nativeGetDefaultResolution = () => {
            return this.getDefaultResolution();
        };
        this.nativeGetDefaultQuality = () => {
            return this.getDefaultQuality();
        };
        this.nativeGetDefaultType = () => {
            return this.getDefaultType().toString();
        };
        this.nativeGetDuration = () => {
            let q38 = this.getDuration();
            return this.getDuration();
        };
        this.nativeGetLoadStartPositionMs = () => {
            return this.getLoadStartPositionMs();
        };
        this.nativeGetNetworkTimeout = () => {
            return this.getNetworkTimeout();
        };
        this.nativeGetNetworkRetryCount = () => {
            return this.getNetworkRetryCount();
        };
        this.nativeGetReferrer = () => {
            return this.getReferrer();
        };
        this.nativeGetCustomHeaders = () => {
            return this.getCustomHeaders();
        };
        if (f38 !== undefined) {
            this.mPreloadDuration = f38;
        }
    }
    getDuration() {
        return this.mPreloadDuration;
    }
    setDuration(e38) {
        this.mPreloadDuration = e38;
    }
    getLoadStartPositionMs() {
        return this.mLoadStartPositionMs;
    }
    setLoadStartPositionMs(d38) {
        this.mLoadStartPositionMs = d38;
    }
    getNetworkTimeout() {
        return this.mNetworkTimeout;
    }
    setNetworkTimeout(c38) {
        this.mNetworkTimeout = c38;
    }
    getNetworkRetryCount() {
        return this.mNetworkRetryCount;
    }
    setNetworkRetryCount(b38) {
        this.mNetworkRetryCount = b38;
    }
    getReferrer() {
        return this.mReferrer;
    }
    setReferrer(a38) {
        this.mReferrer = a38;
    }
    getCustomHeaders() {
        return this.mCustomHeaders;
    }
    setCustomHeaders(z37) {
        this.mCustomHeaders = z37;
    }
    setDefaultResolution(y37) {
        this.mOptionType = PreloadOptionType.RESOLUTION;
        this.mOptionIntValue = y37;
        this.mOptionStringValue = '';
    }
    getDefaultResolution() {
        return (this.mOptionType === PreloadOptionType.RESOLUTION) ? this.mOptionIntValue : 0;
    }
    setDefaultBandWidth(x37) {
        this.mOptionType = PreloadOptionType.BANDWIDTH;
        this.mOptionIntValue = x37;
        this.mOptionStringValue = '';
    }
    getDefaultBandWidth() {
        return (this.mOptionType === PreloadOptionType.BANDWIDTH) ? this.mOptionIntValue : 0;
    }
    setDefaultQuality(w37) {
        this.mOptionType = PreloadOptionType.QUALITY;
        this.mOptionStringValue = w37;
        this.mOptionIntValue = 0;
    }
    getDefaultQuality() {
        return (this.mOptionType === PreloadOptionType.QUALITY) ? this.mOptionStringValue : '';
    }
    getDefaultType() {
        return this.mOptionType;
    }
}
