import premierlibrary from 'libpremierlibrary.so';
export class Logger {
    constructor() {
        this.mValue = -1;
        this.mLogCallback = null;
        this.mEnableConsoleLog = true;
        this.mCurrentLogLevel = LogLevel.AF_LOG_LEVEL_INFO;
        this.nOnLogCallback = (p51, q51) => {
            let r51 = Logger.getLevel(p51);
            if (Logger.sAppContext != null) {
                Logger.getInstance(Logger.sAppContext).callback(r51, q51);
            }
        };
        premierlibrary.nLoggerConstruct(this);
    }
    static getInstance(n51) {
        if (Logger.sInstance == null) {
            Logger.sInstance = new Logger();
            Logger.sInstance.setLogLevel(LogLevel.AF_LOG_LEVEL_INFO);
            if (n51 != null) {
                Logger.sAppContext = n51;
            }
        }
        return Logger.sInstance;
    }
    setLogCallback(m51) {
        this.mLogCallback = m51;
    }
    getLogCallback() {
        return this.mLogCallback;
    }
    setLogLevel(l51) {
        this.mCurrentLogLevel = l51;
        premierlibrary.nLoggerSetLevel(l51);
    }
    setLogOption(j51, k51) {
        switch (j51) {
            case LogOption.FRAME_LEVEL_LOGGING_ENABLED:
                premierlibrary.nLoggerSetOption("frame_level_logging_enabled", k51);
                break;
        }
    }
    getLogLevel() {
        let i51 = premierlibrary.nLoggerGetLevel();
        return Logger.getLevel(i51);
    }
    enableConsoleLog(h51) {
        this.mEnableConsoleLog = h51;
        premierlibrary.nLoggerEnableConsole(h51);
    }
    callback(f51, g51) {
        if (this.mLogCallback != null) {
            this.mLogCallback.onLog(f51, g51);
        }
    }
    static getLevel(e51) {
        switch (e51) {
            case 0:
                return LogLevel.AF_LOG_LEVEL_NONE;
            case 8:
                return LogLevel.AF_LOG_LEVEL_FATAL;
            case 16:
                return LogLevel.AF_LOG_LEVEL_ERROR;
            case 24:
                return LogLevel.AF_LOG_LEVEL_WARNING;
            case 32:
                return LogLevel.AF_LOG_LEVEL_INFO;
            case 48:
                return LogLevel.AF_LOG_LEVEL_DEBUG;
            case 56:
                return LogLevel.AF_LOG_LEVEL_TRACE;
            default:
                return LogLevel.AF_LOG_LEVEL_DEBUG;
        }
    }
}
export var LogLevel;
(function (d51) {
    d51[d51["AF_LOG_LEVEL_NONE"] = 0] = "AF_LOG_LEVEL_NONE";
    d51[d51["AF_LOG_LEVEL_FATAL"] = 8] = "AF_LOG_LEVEL_FATAL";
    d51[d51["AF_LOG_LEVEL_ERROR"] = 16] = "AF_LOG_LEVEL_ERROR";
    d51[d51["AF_LOG_LEVEL_WARNING"] = 24] = "AF_LOG_LEVEL_WARNING";
    d51[d51["AF_LOG_LEVEL_INFO"] = 32] = "AF_LOG_LEVEL_INFO";
    d51[d51["AF_LOG_LEVEL_DEBUG"] = 48] = "AF_LOG_LEVEL_DEBUG";
    d51[d51["AF_LOG_LEVEL_TRACE"] = 56] = "AF_LOG_LEVEL_TRACE";
})(LogLevel || (LogLevel = {}));
export var LogOption;
(function (c51) {
    c51[c51["FRAME_LEVEL_LOGGING_ENABLED"] = 1] = "FRAME_LEVEL_LOGGING_ENABLED";
})(LogOption || (LogOption = {}));
