# 阿里云Harmony播放器SDK
阿里云Harmony播放器SDK为移动端应用提供高效的音视频集成解决方案，支持Harmony开发者快速实现直播、点播等核心视频场景。
## 概述
阿里云视频点播（ApsaraVideo VOD）Harmony NEXT播放器SDK 是轻量化、高性能的视频播放工具，提供从媒体加载、解码渲染到交互控制的全链路解决方案。通过标准化 API 设计与深度场景化封装，开发者可快速实现视频播放功能，并灵活适配在线教育、短视频、企业培训等多种业务场景。
## SDK 特点
* 易于集成
  设计简单，快速上手，提供丰富的API接口和示例，轻松完成SDK安装与视频播放。
* 支持多种播放格式
  支持HLS、RTMP、MP4等多种视频格式和流媒体协议，确保流畅播放。
* 自适应码率
  根据网络状况自动调整视频质量，保证流畅播放体验。
* 丰富的交互功能
  支持全屏播放、快进快退、播放/暂停、音量控制等交互操作，提升用户体验。
## 核心能力说明
### 基础播放功能
支持MP4、HLS、FLV等主流格式播放，具备多分辨率自适应切换能力（清晰度标签可自定义）。播放器集成手势交互，支持双击暂停、滑动调节音量/亮度，并提供全屏播放、倍速调节、首帧预加载等功能。通过回调获取视频元数据（时长、分辨率），支持播放结束自动续播。
### 安全与加密
支持HLS AES-128标准加密与AliyunVodPlayer私有加密，结合服务端密钥管理实现端到端内容保护。支持试看功能，可通过setAuthInfo配置试看时长，或使用setStsToken实现临时身份验证。
### 高级播放特性
低延时直播回看： 基于HTTPDNS的智能调度，支持HLS时移播放。
离线缓存： 本地加密存储，支持断点续传和缓存管理。
AI画质增强： 集成超分辨率、HDR等算法，并支持硬件解码加速。
数据监控： 实时上报缓冲时长、卡顿率等QoS指标。
## 技术架构优势
### 内容分发与加速（CDN支持）
阿里云利用其全球CDN网络和边缘计算技术，通过边缘节点缓存热门视频，减少数据传输距离和延迟，实现视频内容的快速分发和流畅播放。
### 视频安全与版权保护
阿里云Harmony播放器集成DRM技术，结合视频水印和防盗链机制，有效加密内容、标识版权，并防止非法复制与传播，全方位保障视频安全。
### 可扩展性与定制化
阿里云Harmony播放器支持自定义UI界面与功能扩展，开发者可通过SDK和API实现个性化设计及集成广告、社交等功能，同时与阿里云其他服务无缝兼容，满足多样化需求。
### 智能管理与优化
阿里云提供智能转码服务，根据网络与设备自动优化视频播放，结合AI审核功能高效管理视频内容，并通过大数据分析实时监控播放数据，助力优化内容与策略。
### 高性能与稳定性
阿里云Harmony播放器深度优化性能，支持高分辨率流畅播放且低资源占用，适应多种网络环境，通过智能码率切换和缓冲策略保障流畅体验，并内置错误处理机制快速解决问题。
### 丰富的API与开发支持
全面的API支持：阿里云Harmony NEXT播放器提供了丰富的API接口，支持开发者对播放器进行全面控制，包括播放状态查询、播放进度调整。
## 下载安装
ohpm install @aliyun_video_cloud/aliyun_player
## 使用流程
请移步 https://help.aliyun.com/zh/vod/developer-reference/integrated-harmonyos-next-player-sdk?spm=a2c4g.11186623.help-menu-29932.d_4_2_9_0.1f574667PivLXd