import { AVPLBase } from './AVPLBase';
import { Log } from '../utils/Log';
import { UrlVideoPlayer } from './UrlVideoPlayer';
import { OhosUrlListPlayer } from './nativeclass/OhosUrlListPlayer';
export class UrlVideoListPlayer extends AVPLBase {
    constructor(g47, h47) {
        super(g47, h47);
        this.mLog = new Log("NativePlayerBase_UrlVideoListPlayer");
        this.mUrlVideoPlayer = null;
        this.mUrlPrerenderPlayer = null;
    }
    setOnURLSourceExpiredListener(f47) {
        if (this.mUrlVideoPlayer != null) {
            this.mUrlVideoPlayer.setOnURLSourceExpiredListener(f47);
        }
    }
    createListPlayer(b47, c47, d47, e47) {
        return new OhosUrlListPlayer(b47, d47, e47, false);
    }
    getNativePlayerWithContext(z46, a47) {
        if (this.mUrlVideoPlayer == null) {
            this.mUrlVideoPlayer = new UrlVideoPlayer(z46, a47);
        }
        return this.mUrlVideoPlayer;
    }
    getPrerenderPlayerWithContext(x46, y46) {
        if (this.mUrlPrerenderPlayer == null) {
            this.mUrlPrerenderPlayer = new UrlVideoPlayer(x46, y46);
        }
        return this.mUrlPrerenderPlayer;
    }
    getCurrentPlayerIndex() {
        let w46 = super.getCorePlayer();
        if (w46 instanceof OhosUrlListPlayer) {
            this.mLog.info("getCurrentPlayerIndex");
            return w46.getCurrentPlayerIndex();
        }
        return -1;
    }
    getPreRenderPlayer() {
        let u46 = super.getCorePlayer();
        if (u46 instanceof OhosUrlListPlayer) {
            this.mLog.info("getPreRenderPlayer");
            let v46 = u46.getPreRenderPlayerIndex();
            return this.getCurrentPrerenderPlayer(v46);
        }
        return undefined;
    }
    addUrl(r46, s46) {
        let t46 = super.getCorePlayer();
        if (t46 instanceof OhosUrlListPlayer) {
            this.mLog.info("addUrl = " + r46 + " , uid = " + s46);
            t46.addUrl(r46, s46);
        }
    }
    moveToNext() {
        let q46 = super.getCorePlayer();
        if (q46 instanceof OhosUrlListPlayer) {
            this.mLog.info("moveToNext");
            return q46.moveToNext(false);
        }
        return false;
    }
    moveToNextWithPrerendered() {
        let p46 = super.getCorePlayer();
        if (p46 instanceof OhosUrlListPlayer) {
            this.mLog.info("moveToNextWithPrerendered");
            return p46.moveToNext(true);
        }
        return false;
    }
    moveToPrev() {
        let o46 = super.getCorePlayer();
        if (o46 instanceof OhosUrlListPlayer) {
            this.mLog.info("moveToPrev");
            return o46.moveToPrev();
        }
        return false;
    }
    moveTo(m46) {
        let n46 = super.getCorePlayer();
        if (n46 instanceof OhosUrlListPlayer) {
            this.mLog.info("moveTo");
            return n46.moveTo(m46);
        }
        return false;
    }
    setUrlDataSource(k46) {
        let l46 = super.getNativePlayer();
        if (l46.setUrlDataSource !== undefined) {
            l46.setUrlDataSource(k46);
        }
    }
}
