import { AVPBase } from './AVPBase';
import { OhosUrlPlayer } from './nativeclass/OhosUrlPlayer';
import { UrlSource } from './source/UrlSource';
class URLSourceRefreshCallback {
    constructor(c48) {
        this.urlVideoPlayer = c48;
    }
    onSuccess(b48) {
        this.urlVideoPlayer.refreshUrlSource(b48);
    }
    onError(a48) {
        this.urlVideoPlayer.refreshUrlSourceWithError(a48);
    }
}
class URLSourceExpiredListener {
    constructor(z47) {
        this.urlVideoPlayer = z47;
    }
    onUrlSourceExpired(w47, x47) {
        const y47 = new URLSourceRefreshCallback(this.urlVideoPlayer);
        this.urlVideoPlayer.onUrlSourceExpired(w47, y47);
    }
}
export class UrlVideoPlayer extends AVPBase {
    constructor(u47, v47) {
        super(u47, v47);
        this.mOutOnURLSourceExpiredListener = null;
    }
    createAlivcMediaPlayer(s47) {
        let t47 = new OhosUrlPlayer(s47);
        t47.setOnURLSourceExpiredListener(new URLSourceExpiredListener(this));
        return t47;
    }
    setUrlDataSource(q47) {
        let r47 = this.getCorePlayer();
        if (r47 instanceof OhosUrlPlayer) {
            if (q47 instanceof UrlSource) {
                r47.setUrlDataSource(q47);
            }
        }
    }
    setOnURLSourceExpiredListener(p47) {
        this.mOutOnURLSourceExpiredListener = p47;
    }
    onUrlSourceExpired(m47, n47) {
        if (this.mOutOnURLSourceExpiredListener) {
            const o47 = new URLSourceRefreshCallback(this);
            this.mOutOnURLSourceExpiredListener.onUrlSourceExpired(m47, o47);
        }
    }
    refreshUrlSource(k47) {
        let l47 = this.getCorePlayer();
        if (l47 instanceof OhosUrlPlayer) {
            l47.refreshUrlSource(k47);
        }
    }
    refreshUrlSourceWithError(i47) {
        let j47 = this.getCorePlayer();
        if (j47 instanceof OhosUrlPlayer) {
            j47.refreshUrlSourceWithError(i47);
        }
    }
}
