import { SourceBase } from './SourceBase';
import { Definition } from './Definition';
export class VidSourceBase extends SourceBase {
    constructor() {
        super();
        this.mPlayConfig = null;
        this.mOutputType = null;
        this.mStreamTypes = null;
        this.mResultType = null;
        this.mDigitalWatermarkType = null;
        this.nativeGetOutputTypeStr = () => {
            if (this.mOutputType == null) {
                return "";
            }
            else {
                return this.mOutputType.toString();
            }
        };
        this.nativeGetReAuthInfoStr = () => {
            return this.mReAuthInfo;
        };
        this.nativeGetResultTypeStr = () => {
            if (this.mResultType == null) {
                return "";
            }
            else {
                return this.mResultType;
            }
        };
        this.nativeGetStreamTypeStr = () => {
            if (this.mStreamTypes == null || this.mStreamTypes.size == 0) {
                return "";
            }
            let m45 = "";
            for (let n45 of this.mStreamTypes) {
                if (n45 != null) {
                    m45 += n45 + ",";
                }
            }
            if (m45.length > 0) {
                m45 = m45.slice(0, -1);
            }
            return m45;
        };
        this.nativeGetDefinitionStr = () => {
            if (this.mDefinitions == null || this.mDefinitions.length == 0) {
                return "";
            }
            if (this.mDefinitions.includes(Definition.DEFINITION_AUTO, 0)) {
                return Definition.DEFINITION_AUTO;
            }
            let k45 = "";
            for (let l45 of this.mDefinitions) {
                if (l45 != null) {
                    k45 += l45 + ",";
                }
            }
            if (k45.length > 0) {
                k45 = k45.slice(0, -1);
            }
            return k45;
        };
        this.nativeGetPlayerConfigStr = () => {
            if (this.mPlayConfig == null) {
                return "";
            }
            else {
                return this.mPlayConfig.genConfig();
            }
        };
        this.nativeGetFormatStr = () => {
            return this.getFormatStr();
        };
        this.nativeGetAuthTimeout = () => {
            return this.mAuthTimeout;
        };
        this.nativeGetTrace = () => {
            return this.mTrace;
        };
        this.nativeGetDigitalWatermarkTypeStr = () => {
            if (this.mDigitalWatermarkType == null) {
                return "";
            }
            else {
                return this.mDigitalWatermarkType.toString();
            }
        };
        this.mFormats = [];
        this.mDefinitions = [];
        this.mReAuthInfo = "";
        this.mAuthTimeout = 3600;
        this.mTrace = "";
    }
    getPlayerConfig() {
        if (this.mPlayConfig == null) {
            return "";
        }
        else {
            return this.mPlayConfig.genConfig();
        }
    }
    setPlayerConfig(z44) {
        this.mPlayConfig = z44;
    }
    getFormats() {
        return this.mFormats;
    }
    setFormats(y44) {
        this.mFormats = y44;
    }
    getFormatStr() {
        if (this.mFormats.length == 0) {
            return "";
        }
        let w44 = "";
        for (let x44 of this.mFormats) {
            if (x44 != null) {
                w44 += x44 + ",";
            }
        }
        if (w44.length > 0) {
            w44 = w44.slice(0, -1);
        }
        return w44;
    }
    setDefinition(v44) {
        this.mDefinitions = v44;
    }
    getOutputType() {
        return this.mOutputType;
    }
    setOutputType(u44) {
        this.mOutputType = u44;
    }
    setAuthTimeout(t44) {
        this.mAuthTimeout = t44;
    }
    setTrace(s44) {
        this.mTrace = s44;
    }
    setDigitalWatermarkType(r44) {
        this.mDigitalWatermarkType = r44;
    }
    getTrace() {
        return this.mTrace;
    }
    getDigitalWatermarkType() {
        return this.mDigitalWatermarkType;
    }
}
export var OutputType;
(function (q44) {
    q44["oss"] = "oss";
    q44["cdn"] = "cdn";
})(OutputType || (OutputType = {}));
export var StreamType;
(function (p44) {
    p44["video"] = "video";
    p44["audio"] = "audio";
})(StreamType || (StreamType = {}));
export var ResultType;
(function (o44) {
    o44["Single"] = "Single";
    o44["Multiple"] = "Multiple";
})(ResultType || (ResultType = {}));
export var DigitalWatermarkType;
(function (n44) {
    n44["TraceMark"] = "TraceMark";
    n44["CopyrightMark"] = "CopyrightMark";
})(DigitalWatermarkType || (DigitalWatermarkType = {}));
