export class BaseRequest {
    constructor(v49) {
        this.wantStop = false;
        this.outerListener = null;
        this.outerListener = v49;
    }
    getSync() {
        this.runInBackground();
    }
    getAsync() {
        this.runInBackgroundAsync();
    }
    runInBackgroundAsync() {
        setTimeout(() => {
            this.runInBackground();
        }, 0);
    }
    stop() {
        this.wantStop = true;
        this.stopInner();
    }
    sendSuccessResult(s49, t49) {
        if (this.wantStop) {
            return;
        }
        if (this.outerListener) {
            this.outerListener.onSuccess(s49, t49);
        }
    }
    sendFailResult(p49, q49, r49) {
        if (this.wantStop) {
            return;
        }
        if (this.outerListener) {
            this.outerListener.onFail(p49, q49, r49);
        }
    }
    dealMsg(o49) {
        if (o49.id == BaseRequest.WHAT_SUCCESS) {
            this.outerListener?.onSuccess(o49.data, o49.extra);
        }
        else if (o49.id == BaseRequest.WHAT_FAIL) {
            this.outerListener?.onFail(o49.failCode, o49.data, o49.extra);
        }
    }
}
BaseRequest.WHAT_SUCCESS = 1;
BaseRequest.WHAT_FAIL = 0;
BaseRequest.DATA_KEY_EXTRA = "data_extra";
