import http from '@ohos.net.http';
import util from "@ohos.util";
export class HttpClientHelper {
    constructor(s50) {
        this.mReferer = null;
        this.urlRequest = null;
        this.mNetworkTimeout = HttpClientHelper.CONNECTION_TIMEOUT;
        this.mHttpProxy = null;
        this.mUserAgent = null;
        this.mCustomHeaders = [{}];
        this.mUrl = s50;
    }
    setRefer(r50) {
        this.mReferer = r50;
    }
    setTimeout(q50) {
        this.mNetworkTimeout = q50;
    }
    setHttpProxy(p50) {
        this.mHttpProxy = p50;
    }
    setUserAgent(o50) {
        this.mUserAgent = o50;
    }
    setCustomHeaders(n50) {
        this.mCustomHeaders = n50;
    }
    stop() {
        if (this.urlRequest != null) {
            setTimeout(() => {
                this.urlRequest?.destroy();
            }, 0);
        }
    }
    async doGet() {
        if (this.mUrl.startsWith("https://") || this.mUrl.startsWith("http://")) {
            this.urlRequest = http.createHttp();
        }
        else {
            return null;
        }
        if (this.urlRequest == null) {
            return null;
        }
        let z49 = [];
        if (this.mReferer != null) {
            z49.push({ 'Referer': this.mReferer });
        }
        if (this.mUserAgent != null) {
            z49.push({ 'User-Agent': this.mUserAgent });
        }
        if (this.mCustomHeaders.length > 0) {
            for (let l50 of this.mCustomHeaders) {
                if (l50 != null) {
                    z49.push(l50);
                }
            }
        }
        let a50 = "";
        let b50 = false;
        if (this.mHttpProxy != null) {
            a50 = this.mHttpProxy;
            b50 = true;
        }
        else {
            a50 = this.mUrl;
        }
        let c50 = {
            method: http.RequestMethod.GET,
            header: z49,
            connectTimeout: this.mNetworkTimeout,
            readTimeout: this.mNetworkTimeout,
            usingProxy: b50,
        };
        return new Promise((e50, f50) => {
            if (this.urlRequest == null) {
                e50(null);
                return;
            }
            this.urlRequest.request(a50, c50, (h50, i50) => {
                if (h50) {
                    console.error('error:' + JSON.stringify(h50));
                    this.urlRequest?.destroy();
                    e50(null);
                    return;
                }
                if (i50.responseCode == http.ResponseCode.OK) {
                    if (i50.resultType == http.HttpDataType.STRING) {
                        e50(i50.result);
                    }
                    else if (i50.resultType == http.HttpDataType.ARRAY_BUFFER) {
                        let j50 = util.TextDecoder.create('utf-8');
                        let k50 = j50.decodeToString(new Uint8Array(i50.result));
                        e50(k50 ? k50 : null);
                    }
                    else {
                        console.info("response failed, resultType: " + i50.resultType);
                        this.urlRequest?.destroy();
                        e50(null);
                    }
                }
                else {
                    console.info("response failed, responseCode is " + i50.responseCode);
                    this.urlRequest?.destroy();
                    e50(null);
                }
            });
        });
    }
}
HttpClientHelper.CONNECTION_TIMEOUT = 10000;
