"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var Hash_1 = __importDefault(require("./Hash"));
function getMapData(_a, key) {
    var wdkData = _a.wdkData;
    var data = wdkData;
    return isKeyable(key)
        ? data[typeof key === 'string' ? 'string' : 'hash']
        : data.map;
}
// value是否是基本类型，适合作为map的key
function isKeyable(value) {
    var type = typeof value;
    return (type === 'string' || type === 'number' || type === 'symbol' || type === 'boolean')
        ? (value !== '__proto__')
        : (value === null);
}
var MapCache = /** @class */ (function () {
    // entries: 二维数组的名值对
    function MapCache(entries) {
        this.size = 0;
        this.wdkData = {
            hash: new Hash_1.default(undefined),
            map: new Map(),
            string: new Hash_1.default(undefined),
        };
        var index = -1;
        var length = entries == null ? 0 : entries.length;
        while (++index < length) {
            var entry = entries[index];
            this.set(entry[0], entry[1]);
        }
    }
    MapCache.prototype.clear = function () {
        this.size = 0;
        this.wdkData = {
            hash: new Hash_1.default(undefined),
            map: new Map(),
            string: new Hash_1.default(undefined),
        };
    };
    MapCache.prototype.delete = function (key) {
        var result = getMapData(this, key).delete(key);
        this.size -= result ? 1 : 0;
        return result;
    };
    MapCache.prototype.get = function (key) {
        return getMapData(this, key).get(key);
    };
    MapCache.prototype.has = function (key) {
        return getMapData(this, key).has(key);
    };
    MapCache.prototype.set = function (key, value) {
        var data = getMapData(this, key);
        var size = data.size;
        data.set(key, value);
        this.size += data.size === size ? 0 : 1;
        return this;
    };
    return MapCache;
}());
exports.default = MapCache;
