"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var toString_1 = __importDefault(require("./toString"));
/**
 * escape时要处理的字符串
 */
var htmlEscapes = {
    '&': '&amp;',
    '<': '&lt;',
    '>': '&gt;',
    '"': '&quot;',
    "'": '&#39;',
};
/**
 * 相关特殊字符的正则匹配
 */
var escapedHtmlRule = /[&<>"']/g;
/**
 * 处理输入的字符串中的特殊字符
 *
 * @export
 * @param {(string | null)} [input] 输入的字符串
 * @returns {string} 处理后的字符串
 */
function escape(input) {
    return (0, toString_1.default)(input).replace(escapedHtmlRule, function (key) {
        return htmlEscapes[key];
    });
}
exports.default = escape;
