"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("./common/utils");
var matches_1 = __importDefault(require("./matches"));
var get_1 = __importDefault(require("./get"));
var matchesProperty_1 = __importDefault(require("./matchesProperty"));
var keys_1 = __importDefault(require("./keys"));
var identity_1 = __importDefault(require("./identity"));
/**
 * 判断collection中每个元素是否经predicate调用后是否都返回真值，如果是则返回true否则返回false
 * @param collection，用于判断的元素的集合
 * @param predicate，
 *        用于对每个元素进行判断，返回true或者false。
 *        如果是一个函数，则将元素作为入参，如果是一个对象，则使用isMatch的规则来比较元素和该对象是否相匹配
 *
 * @return 返回一个boolean，如果collection所有元素经predicate检查都为真值，则返回true否则返回false
 */
function every(collection, predicate) {
    var e_1, _a;
    // array是真正用于检查的数组
    var array = Array.isArray(collection) ? collection : (0, keys_1.default)(collection);
    var type = typeof predicate;
    // 真正用于判断array中每个元素是否为真值的函数，如果predicate是nullish则使用identity函数
    var judgeFunc = predicate === undefined || predicate === null ? identity_1.default : function () { return true; };
    if (type === 'function') {
        judgeFunc = predicate;
    }
    else if (type === 'string') {
        judgeFunc = function (element) { return (0, get_1.default)(element, predicate); };
    }
    else if ((0, utils_1.tagName)(predicate) === '[object Object]') {
        judgeFunc = (0, matches_1.default)(predicate);
    }
    else if (Array.isArray(predicate)) {
        judgeFunc = (0, matchesProperty_1.default)(predicate[0], predicate[1]);
    }
    try {
        for (var array_1 = __values(array), array_1_1 = array_1.next(); !array_1_1.done; array_1_1 = array_1.next()) {
            var element = array_1_1.value;
            if (!judgeFunc(element)) {
                return false;
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (array_1_1 && !array_1_1.done && (_a = array_1.return)) _a.call(array_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return true;
}
exports.default = every;
