"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.numMulti = void 0;
var isNaN_1 = __importDefault(require("./isNaN"));
var toNumber_1 = __importDefault(require("./toNumber"));
/**
 * 处理乘法的精度问题
 * @param num1
 * @param num2
 */
function numMulti(num1, num2) {
    var baseNum = 0;
    try {
        baseNum += num1.toString().split('.')[1].length;
    }
    catch (e) {
    }
    try {
        baseNum += num2.toString().split('.')[1].length;
    }
    catch (e) {
    }
    return Number(num1.toString().replace('.', '')) * Number(num2.toString().replace('.', '')) / (Math.pow(10, baseNum));
}
exports.numMulti = numMulti;
/**
 * 向下取整
 * @param input
 * @param precision
 */
function floor(input, precision) {
    if (precision === void 0) { precision = 0; }
    if (typeof Number(input) !== 'number') {
        return Number.NaN;
    }
    if (input === Number.MAX_SAFE_INTEGER || input === Number.MIN_SAFE_INTEGER) {
        return input;
    }
    var newPrecision = (0, isNaN_1.default)(precision) ? 0 : Math.floor((0, toNumber_1.default)(precision));
    var newInput = Number(input);
    if (newPrecision === 0) {
        return Math.floor(newInput);
    }
    var baseNumber = Math.pow(10, Math.abs(newPrecision));
    if (baseNumber === Number.POSITIVE_INFINITY || baseNumber === Number.NEGATIVE_INFINITY) {
        return input;
    }
    if (newInput >= 0 && (1 / newInput > 0)) {
        if (newPrecision > 0) {
            return Math.floor(numMulti(Math.abs(newInput), baseNumber)) / baseNumber;
        }
        if (newPrecision < 0) {
            return numMulti(Math.floor(Math.abs(newInput) / baseNumber), baseNumber);
        }
    }
    else {
        if (newPrecision > 0) {
            return -(Math.ceil(numMulti(Math.abs(newInput), baseNumber)) / baseNumber);
        }
        if (newPrecision < 0) {
            return -numMulti(Math.ceil(Math.abs(newInput) / baseNumber), baseNumber);
        }
    }
    return 0;
}
exports.default = floor;
