"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("./common/utils");
/**
 * 判断传入的值是否是布尔值，并返回。
 * 如果是布尔值则返回true，其他情况都返回false
 * @Catalog core
 * @param value {any} 待判断的值
 * @returns boolean
 */
function isBoolean(value) {
    return (0, utils_1.tagName)(value) === '[object Boolean]';
}
exports.default = isBoolean;
