"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * 检查指定的 value 是否是一个整数.
 *
 * <B>Note: This method is based on Number.isInteger.</B>
 * @param value(any) 待被检查的数
 * @returns boolean 如果是整数返回 true，否则返回 false
 *
 * @example
 * _.isInteger(3);
 * // => true
 *
 * _.isInteger(Number.MIN_VALUE);
 * // => false
 *
 * _.isInteger(Infinity);
 * // => false
 *
 * _.isInteger('3');
 * // => false
 */
function isInteger(value) {
    if (value === void 0) { value = undefined; }
    return Number.isInteger(value);
}
exports.default = isInteger;
