/**
 * 为给指定对象 path 上设置值。如果指定的 path 不存在，那么就创建一个；
 * 如果路径中指定了序号属性，那么会创建数组（如果对象中此属性不是数组）。
 *
 * **Note:** 该方法会修改 `object` 的值。
 *
 * @category Lang
 * @param {Object} object 待修改的对象
 * @param {Array|string} path 设置值的属性路径
 * @param {*} value 设置的值
 * @returns {Object} 返回 `object`.
 * @example
 *
 * var object = { 'a': [{ 'b': { 'c': 3 } }] };
 *
 * _.set(object, 'a[0].b.c', 4);
 * console.log(object.a[0].b.c);
 * // => 4
 *
 * _.set(object, ['x', '0', 'y', 'z'], 5);
 * console.log(object.x[0].y.z);
 * // => 5
 */
export default function set(object: Object, path: any | any[], value: any): Object;
