"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var isEmpty_1 = __importDefault(require("./isEmpty"));
var slice_1 = __importDefault(require("./slice"));
/**
 * 从给定数组中取前 n 个元素返回新数组
 *
 * @param {ArrayLike<any> | undefined} from 给定数组.
 * @param {number} [n=1] 要取的元素数量，默认为 1
 * @returns 最多包含 n 个元素的新数组
 * @example
 *
 * take([1, 2, 3])
 * // => [1]
 *
 * take([1, 2, 3], 2)
 * // => [1, 2]
 *
 * take([1, 2, 3], 5)
 * // => [1, 2, 3]
 *
 * take([1, 2, 3], 0)
 * // => []
 */
function take(from, n) {
    if (n === void 0) { n = 1; }
    if ((0, isEmpty_1.default)(from)) {
        return [];
    }
    return (0, slice_1.default)(from, 0, n < 0 ? 0 : n);
}
exports.default = take;
