"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var isNil_1 = __importDefault(require("./isNil"));
var sameValueZero_1 = __importDefault(require("./common/sameValueZero"));
/**
 * 创建一个剔除所有给定值的新数组，剔除值的时候，使用SameValueZero做相等比较。
 * 注意: 不像_.pull, 这个方法会返回一个新数组。
 * @param array (Array): 要检查的数组。
 * @param values  (...*): 要剔除的值。
 * @returns (Array): 返回过滤值后的新数组。
 * @example
 * _.without([2, 1, 2, 3], 1, 2);
 * // => [3]
 */
function without(array) {
    var values = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        values[_i - 1] = arguments[_i];
    }
    if ((0, isNil_1.default)(values)) {
        return [].concat(array);
    }
    return array.filter(function (v) {
        var vIdx = values.findIndex(function (item) {
            return (0, sameValueZero_1.default)(v, item);
        });
        return vIdx === -1;
    });
}
exports.default = without;
