import { TargetTaskService } from '@ohos/hvigor-ohos-plugin/src/tasks/service/target-task-service.js';
import { BaseOhosModuleTask } from '../../base/base-ohos-module-task.js';
import { TaskDetails } from '@ohos/hvigor';
import { ApiConfigJson } from '../../../options/api-config-json.js';
import ApiConfigObj = ApiConfigJson.ApiConfigObj;
import ApiConifgObj = ApiConfigJson.ApiConfigObj;
/**
 * 处理依赖的arkui-sdk 的公共基类
 *
 * @since 2023/05/08
 */
export declare class BaseProcessSdkLib extends BaseOhosModuleTask {
    sdkApiMappingJsonPath: string | undefined;
    sdkApiMappingObj: ApiConifgObj[] | undefined;
    readonly sdkApiConfigJsonPath: string;
    readonly sdkEngineApiConfigJsonObj: ApiConifgObj[];
    constructor(taskService: TargetTaskService, taskDetails: TaskDetails);
    initTaskDepends(): void;
    findSdkApiLib(sdkApiMappingData: ApiConifgObj[] | undefined, callback?: Function): void;
    copyApiDeps(deps: string[] | undefined, systemType: string, copiedDeps: Map<string, boolean>, callback?: Function): void;
    copyIosDeps(apiObj: ApiConfigObj, addXcFrameworks: string[]): void;
    copyAndroidDeps(apiObj: ApiConfigObj): void;
}
