"use strict";var __importDefault=this&&this.__importDefault||function(s){return s&&s.__esModule?s:{default:s}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.PackageIosApp=void 0;const cross_platform_task_names_js_1=require("../common/const/cross-platform-task-names.js"),ohos_logger_js_1=require("@ohos/hvigor-ohos-plugin/src/utils/log/ohos-logger.js"),base_ohos_project_task_js_1=require("./base/base-ohos-project-task.js"),task_names_js_1=require("@ohos/hvigor-ohos-plugin/src/tasks/common/task-names.js"),path_1=__importDefault(require("path")),process_utils_js_1=require("@ohos/hvigor-ohos-plugin/src/utils/process-utils.js"),cross_platform_service_js_1=require("../service/cross-platform-service.js"),common_const_js_1=require("../common/const/common-const.js"),fs_1=__importDefault(require("fs"));class PackageIosApp extends base_ohos_project_task_js_1.BaseOhosProjectTask{constructor(s){super(s,cross_platform_task_names_js_1.CrossPlatformTaskNames.Task.PACKAGE_IOS_APP),this.log=ohos_logger_js_1.OhosLogger.getLogger(PackageIosApp.name),this.iosProjectDir=this.crossPlatformPathInfo.getIosProjectDir(),this.buildMode=cross_platform_service_js_1.crossPlatformService.isDebug()?common_const_js_1.BuildMode.DEBUG:common_const_js_1.BuildMode.RELEASE}initTaskDepends(){this.dependsOn(task_names_js_1.TaskNames.Task.PACKAGE_APP.name)}async doTaskAction(){this.isApplication?await this.buildApp():await this.buildLibrary()}async buildApp(){this.log.debug("Executing the IOS application package...");const s=this.crossPlatformPathInfo.getIosXcodeprojDir(),o=path_1.default.resolve(this.iosProjectDir,"build/outputs/app/"),e=this.signaturExists(),t=`xcodebuild -project ${s} -sdk iphoneos -configuration ${this.buildMode} clean build CONFIGURATION_BUILD_DIR=${o} ${e?"":"CODE_SIGNING_ALLOWED=NO CODE_SIGNING_REQUIRED=NO CODE_SIGNING_IDENTITY=''"}`;await this.executeBuildCommand(t)}async buildLibrary(){this.log.debug("Executing the IOS framework package...");const s=this.crossPlatformPathInfo.getIosProjectDir(),o=this.crossPlatformPathInfo.getIosXcodeprojDir(),e=path_1.default.resolve(s,"build/outputs/framework/"),t=`xcodebuild -project ${o} clean build CONFIGURATION_BUILD_DIR=${e} `,r=`xcodebuild -create-xcframework -framework ${e}/myframework.framework -output ${e}/myframework.xcframework`;await this.executeBuildCommand(t),await this.executeBuildCommand(r)}async executeBuildCommand(s){this.log._printDebugCommand("xcodebuild:",[s]),await(new process_utils_js_1.ProcessUtils).execaCommand(s,{cwd:this.iosProjectDir,shell:!0,windowsHide:!0})}signaturExists(){const s=cross_platform_service_js_1.crossPlatformService.getPathInfo().getIosPbxProjPath(),o=fs_1.default.readFileSync(s,"utf8").split("\n"),e=o.findIndex((s=>s.indexOf("PROVISIONING_PROFILE_SPECIFIER")>-1));return!o[e].includes("no sign")}}exports.PackageIosApp=PackageIosApp;