"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var HASH_UNDEFINED = '__wdk_hash_undefined__';
var Hash = /** @class */ (function () {
    // entries: key-value形式的二维数组
    function Hash(entries) {
        this.wdkData = Object.create(null);
        this.size = 0;
        var index = -1;
        var length = entries == null ? 0 : entries.length;
        while (++index < length) {
            var entry = entries[index];
            this.set(entry[0], entry[1]);
        }
    }
    Hash.prototype.clear = function () {
        this.wdkData = Object.create(null);
        this.size = 0;
    };
    Hash.prototype.delete = function (key) {
        var result = this.has(key) && delete this.wdkData[key];
        this.size -= result ? 1 : 0;
        return result;
    };
    Hash.prototype.get = function (key) {
        var data = this.wdkData;
        var result = data[key];
        return result === HASH_UNDEFINED ? undefined : result;
    };
    Hash.prototype.has = function (key) {
        var data = this.wdkData;
        return data[key] !== undefined;
    };
    Hash.prototype.set = function (key, value) {
        var data = this.wdkData;
        this.size += this.has(key) ? 0 : 1;
        data[key] = value === undefined ? HASH_UNDEFINED : value;
        return this;
    };
    return Hash;
}());
exports.default = Hash;
