"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.baseDifference = void 0;
var baseFindIndex_1 = require("./baseFindIndex");
var map_1 = __importDefault(require("../map"));
var SetCache_1 = require("./SetCache");
var LARGE_ARRAY_SIZE = 200;
function baseDifference(array, values, iteratee, comparator) {
    var e_1, _a;
    var includes = baseFindIndex_1.arrayIncludes;
    var isCommon = true;
    var result = [];
    var tmpValues = values;
    var valuesLength = tmpValues.length;
    var isIterateeFunc = typeof iteratee === 'function';
    if (!(array === null || array === void 0 ? void 0 : array.length)) {
        return result;
    }
    if (iteratee) {
        tmpValues = (0, map_1.default)(tmpValues, function (value) { return (isIterateeFunc ? iteratee(value) : value[iteratee]); });
    }
    if (comparator) {
        includes = baseFindIndex_1.arrayIncludesWith;
        isCommon = false;
    }
    else if (tmpValues.length >= LARGE_ARRAY_SIZE) {
        includes = baseFindIndex_1.cacheHas;
        isCommon = false;
        tmpValues = new SetCache_1.SetCache(tmpValues);
    }
    var isFindEqual = false;
    try {
        for (var array_1 = __values(array), array_1_1 = array_1.next(); !array_1_1.done; array_1_1 = array_1.next()) {
            var value = array_1_1.value;
            var computed = value;
            if (iteratee) {
                computed = isIterateeFunc ? iteratee(value) : value[iteratee];
            }
            value = (comparator || value !== 0) ? value : 0;
            if (isCommon && !Number.isNaN(computed)) {
                var valuesIndex = valuesLength;
                while (valuesIndex--) {
                    if (tmpValues[valuesIndex] === computed) {
                        isFindEqual = true;
                        break;
                    }
                }
                if (isFindEqual) {
                    isFindEqual = false;
                    continue;
                }
                result.push(value);
            }
            else if (!includes(tmpValues, computed, comparator)) {
                result.push(value);
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (array_1_1 && !array_1_1.done && (_a = array_1.return)) _a.call(array_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return result;
}
exports.baseDifference = baseDifference;
