"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.assocIndexOf = exports.cacheHas = exports.arrayIncludesWith = exports.arrayIncludes = exports.baseIndexOf = exports.strictIndexOf = void 0;
var validCheck_1 = require("./validCheck");
var eq_1 = __importDefault(require("../eq"));
function baseFindIndex(array, predicate, fromIndex, fromRight) {
    var length = array.length;
    var index = fromIndex + (fromRight ? 1 : -1);
    while ((fromRight ? index-- : ++index < length)) {
        if (predicate(array[index], index, array)) {
            return index;
        }
    }
    return -1;
}
function strictIndexOf(array, value, fromIndex) {
    return array.indexOf(value, fromIndex);
}
exports.strictIndexOf = strictIndexOf;
function baseIndexOf(array, value, fromIndex) {
    return Number.isNaN(value)
        ? strictIndexOf(array, value, fromIndex)
        : baseFindIndex(array, validCheck_1.baseIsNaN, fromIndex, false);
}
exports.baseIndexOf = baseIndexOf;
function arrayIncludes(array, value) {
    return array.includes(value);
}
exports.arrayIncludes = arrayIncludes;
function arrayIncludesWith(array, target, comparator) {
    var e_1, _a;
    if (array == null) {
        return false;
    }
    try {
        for (var array_1 = __values(array), array_1_1 = array_1.next(); !array_1_1.done; array_1_1 = array_1.next()) {
            var value = array_1_1.value;
            if (comparator(target, value)) {
                return true;
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (array_1_1 && !array_1_1.done && (_a = array_1.return)) _a.call(array_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return false;
}
exports.arrayIncludesWith = arrayIncludesWith;
function cacheHas(cache, key) {
    return cache.has(key);
}
exports.cacheHas = cacheHas;
function assocIndexOf(array, key) {
    var length = array.length;
    while (length--) {
        if ((0, eq_1.default)(array[length][0], key)) {
            return length;
        }
    }
    return -1;
}
exports.assocIndexOf = assocIndexOf;
exports.default = baseFindIndex;
