"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.equalArrays = void 0;
var SetCache_1 = require("./SetCache");
var baseFindIndex_1 = require("./baseFindIndex");
var COMPARE_PARTIAL_FLAG = 1;
var COMPARE_UNORDERED_FLAG = 2;
// 比较多维数组是否相等
function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
    var isPartial = bitmask & COMPARE_PARTIAL_FLAG;
    var arrLength = array.length;
    var othLength = other.length;
    if (checkLen(arrLength, othLength, isPartial) === false) {
        return false;
    }
    // 检测环状引用变量是否相等
    var recursiveRet = checkRecursive(stack, array, other);
    if (recursiveRet !== undefined) {
        return recursiveRet;
    }
    var index = -1;
    var result = true;
    var seen = (bitmask & COMPARE_UNORDERED_FLAG) ? new SetCache_1.SetCache(undefined) : undefined;
    stack.set(array, other);
    stack.set(other, array);
    while (++index < arrLength) {
        var compared = void 0;
        var arrValue = array[index];
        var othValue = other[index];
        if (customizer) {
            compared = isPartial
                ? customizer(othValue, arrValue, index, other, array, stack)
                : customizer(arrValue, othValue, index, array, other, stack);
        }
        if (compared !== undefined) {
            if (compared) {
                continue;
            }
            result = false;
            break;
        }
        if (recursiveCompareArray(seen, other, arrValue, bitmask, customizer, stack, equalFunc, othValue) === false) {
            result = false;
            break;
        }
    }
    stack.delete(array);
    stack.delete(other);
    return result;
}
exports.equalArrays = equalArrays;
function checkRecursive(stack, array, other) {
    var arrStacked = stack.get(array);
    var othStacked = stack.get(other);
    if (arrStacked && othStacked) {
        return arrStacked === other && othStacked === array;
    }
}
function checkLen(arrLength, othLength, isPartial) {
    if (arrLength !== othLength && !(isPartial && othLength > arrLength)) {
        return false;
    }
}
function recursiveCompareArray(seen, other, arrValue, bitmask, customizer, stack, equalFunc, othValue) {
    if (seen) {
        if (compareArray(seen, other, arrValue, bitmask, customizer, stack, equalFunc)) {
            return false;
        }
    }
    else if (!(arrValue === othValue
        || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
        return false;
    }
    return undefined;
}
function compareArray(seen, other, arrValue, bitmask, customizer, stack, equalFunc) {
    return !arraySome(other, function (othValueInner, othIndex) {
        if (!(0, baseFindIndex_1.cacheHas)(seen, othIndex)
            && (arrValue === othValueInner || equalFunc(arrValue, othValueInner, bitmask, customizer, stack))) {
            return seen.push(othIndex);
        }
    });
}
// 与Array.some等价
function arraySome(array, predicate) {
    var index = -1;
    var length = array == null ? 0 : array.length;
    while (++index < length) {
        if (predicate(array[index], index, array)) {
            return true;
        }
    }
    return false;
}
