/**
 * 将指定的字符串类型的path（对象path），转换成数组类型。
 * @param strPath 字符串类型的path
 * @returns 按照path规则将字符串拆分成数组
 * @example
 * const stringPaths = 'a[-1.23]["[\\"b\\"]"].c[\'[\\\'d\\\']\'][\ne\n][f].g';
 * const paths = stringToPaths(stringPaths);
 * // => ['a', '-1.23', '"[\\"b\\"]"', 'c', '\'[\\\'d\\\']\'', '\ne\n', 'f', 'g']
 */
export default function stringToPaths(strPath: string): string[];
/**
 * 根据广义的路径得到对于obj而言合理的属性路径
 * @param obj，路径所属的obj
 * @param rawPath，广义的路径，可以是字符串或者数组
 * @return 对obj合理的属性路径
 */
export declare function getObjValidPathFromGeneralPath(obj: Object, rawPath: string[] | string | symbol): (string | symbol)[];
