"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.toString = void 0;
var isArray_1 = __importDefault(require("../isArray"));
var isSymbol_1 = __importDefault(require("../isSymbol"));
function toString(value) {
    return value == null ? '' : baseToString(value);
}
exports.toString = toString;
var INFINITY = 1 / 0;
var symbolProto = Symbol ? Symbol.prototype : undefined;
var symbolToString = symbolProto ? symbolProto.toString : undefined;
function baseToString(value) {
    if (typeof value === 'string') {
        return value;
    }
    if ((0, isArray_1.default)(value)) {
        return "".concat(arrayMap(value, baseToString));
    }
    if ((0, isSymbol_1.default)(value)) {
        return symbolToString ? symbolToString.call(value) : '';
    }
    var result = ("".concat(value));
    return (result === '0' && (1 / value) === -INFINITY) ? '-0' : result;
}
function arrayMap(collection, iteratee) {
    return collection.map(iteratee);
}
