"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.isFlattenable = exports.isArguments = exports.baseIsNaN = exports.isPrototype = exports.isIterate = exports.isArray = exports.isLength = exports.isEqual = exports.isIndex = exports.isObject = void 0;
var getTag_1 = __importDefault(require("./getTag"));
function isObject(obj) {
    var type = typeof obj;
    return obj != null && (type === 'object' || type === 'function');
}
exports.isObject = isObject;
// 匹配正整数
var reIsUint = /^(?:0|[1-9]\d*)$/;
// 判断数组下标的合法性
function isIndex(value, length) {
    var type = typeof value;
    var len = length;
    len = len == null ? Number.MAX_SAFE_INTEGER : len;
    return !!len
        && (type === 'number'
            || (type !== 'symbol' && reIsUint.test(value)))
        && (value > -1 && value % 1 === 0 && value < len);
}
exports.isIndex = isIndex;
function isEqual(value, other) {
    return value === other || (Number.isNaN(value) && Number.isNaN(other));
}
exports.isEqual = isEqual;
function isLength(value) {
    return typeof value === 'number'
        && value > -1 && value % 1 === 0 && value <= Number.MAX_SAFE_INTEGER;
}
exports.isLength = isLength;
function isArray(array) {
    return array != null && typeof array !== 'function' && isLength(array.length);
}
exports.isArray = isArray;
function isIterate(value, index, object) {
    if (!isObject(object)) {
        return false;
    }
    var type = typeof index;
    if (type === 'number'
        ? (isArray(object) && isIndex(index, object.length))
        : (type === 'string' && index in object)) {
        return isEqual(object[index], value);
    }
    return false;
}
exports.isIterate = isIterate;
var objectProto = Object.prototype;
function isPrototype(value) {
    var Ctor = value && value.constructor;
    var proto = (typeof Ctor === 'function' && Ctor.prototype) || objectProto;
    return value === proto;
}
exports.isPrototype = isPrototype;
function baseIsNaN(value) {
    return Number.isNaN(value);
}
exports.baseIsNaN = baseIsNaN;
function isArguments(value) {
    return isObject(value) && (0, getTag_1.default)(value) === '[object Arguments]';
}
exports.isArguments = isArguments;
var spreadableSymbol = Symbol.isConcatSpreadable;
function isFlattenable(value) {
    return Array.isArray(value) || isArguments(value)
        || !!(value && value[spreadableSymbol]);
}
exports.isFlattenable = isFlattenable;
