"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var isObject_1 = __importDefault(require("./isObject"));
var setValueForKey = function (result, key, item) {
    if (!Object.prototype.hasOwnProperty.call(result, key)) {
        result[key] = [];
    }
    result[key].push(item);
};
var groupByForArray = function (collection, iteratee) {
    var result = {};
    if (typeof iteratee === 'string') {
        collection.forEach(function (item) {
            var key = item[iteratee];
            setValueForKey(result, "".concat(key), item);
        });
    }
    else {
        collection.forEach(function (item) {
            if ((Array.isArray(item) || (0, isObject_1.default)(item)) && typeof iteratee === 'number') {
                setValueForKey(result, item[iteratee], item);
            }
            else {
                var key = iteratee && iteratee(item);
                key = !key ? item : key;
                setValueForKey(result, "".concat(key), item);
            }
        });
    }
    return result;
};
var groupByForObject = function (collection, iteratee) {
    var result = {};
    Object.keys(collection).forEach(function (key) {
        var newKey = iteratee && iteratee(collection[key]);
        setValueForKey(result, "".concat(newKey), collection[key]);
    });
    return result;
};
/**
 * 创建一个对象，key 是 iteratee 遍历 collection(集合) 中的每个元素返回的结果。
 * 分组值的顺序是由他们出现在 collection(集合) 中的顺序确定的。每个键对应的值负责生成 key 的元素组成的数组。
 * 返回一个组成聚合的对象。
 * @param collection （array/object）
 * @param iteratee
 */
function groupBy(collection, iteratee) {
    if (Object.prototype.toString.call(collection) === '[object Array]') {
        return groupByForArray(collection, iteratee);
    }
    return groupByForObject(collection, iteratee);
}
exports.default = groupBy;
