/**
 * 打点数据构建时间解析
 *
 * @since 2022/6/11
 */
declare class TraceBuildAnalyze {
    private readonly data;
    constructor();
    getData(): {
        totalTime: number;
        moduleNum: number;
        isIncremental: boolean;
        hasIncremental: boolean;
        isParallel: boolean;
        aotCompileMode?: string | undefined;
        IS_DAEMON: boolean;
        LOG_LEVEL: string;
        IS_HVIGORFILE_TYPE_CHECK: boolean;
        PRODUCTS: Record<string, any>[];
        MODULES: Record<string, any>[];
        BUILD_MODE_SET: Record<string, any>[];
        HVIGOR_INSTALL_TIME?: number | undefined;
        /**
         * 打点数据Task执行时间
         * 取多个模块相同任务执行时间的最大值
         * 时间单位是纳秒
         */
        taskTime: Record<string, number>;
    };
    set(key: string, value: any): void;
}
export declare const traceBuildAnalyze: TraceBuildAnalyze;
interface HvigorTrace {
    totalTime: number;
    moduleNum: number;
    isIncremental: boolean;
    hasIncremental: boolean;
    isParallel: boolean;
    aotCompileMode?: string;
    IS_DAEMON: boolean;
    LOG_LEVEL: string;
    IS_HVIGORFILE_TYPE_CHECK: boolean;
    PRODUCTS: Record<string, any>[];
    MODULES: Record<string, any>[];
    BUILD_MODE_SET: Record<string, any>[];
    HVIGOR_INSTALL_TIME?: number;
    /**
     * 打点数据Task执行时间
     * 取多个模块相同任务执行时间的最大值
     * 时间单位是纳秒
     */
    taskTime: Record<string, number>;
}
export declare const hvigorTrace: HvigorTrace;
export {};
